<?php
$wp_customize->add_section(
    'single_author_options',
    array(
        'title' => esc_html__( 'Single Author Post Options', 'newsberry' ),
        'panel' => 'single_options_panel',
    )
);
/*Show Author Posts
*-----------------------------------------*/
$wp_customize->add_setting(
    'newsberry_options[show_author_posts]',
    array(
        'default'           => $newsberry_default['show_author_posts'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[show_author_posts]',
    array(
        'label'    => __( 'Show Author Posts', 'newsberry' ),
        'section'  => 'single_author_options',
        'type'     => 'checkbox',
    )
);

/*Author Posts Text.*/
$wp_customize->add_setting(
    'newsberry_options[author_posts_text]',
    array(
        'default'           => $newsberry_default['author_posts_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[author_posts_text]',
    array(
        'label'    => __( 'Author Posts Text', 'newsberry' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

/* Number of Author Posts */
$wp_customize->add_setting(
    'newsberry_options[no_of_author_posts]',
    array(
        'default'           => $newsberry_default['no_of_author_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[no_of_author_posts]',
    array(
        'label'       => __( 'Number of Author Posts', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'number',
    )
);

/*Author Posts Orderby*/
$wp_customize->add_setting(
    'newsberry_options[author_posts_orderby]',
    array(
        'default'           => $newsberry_default['author_posts_orderby'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[author_posts_orderby]',
    array(
        'label'       => __( 'Orderby', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'date' => __('Date', 'newsberry'),
            'id' => __('ID', 'newsberry'),
            'title' => __('Title', 'newsberry'),
            'rand' => __('Random', 'newsberry'),
        ),
    )
);

/*Author Posts Order*/
$wp_customize->add_setting(
    'newsberry_options[author_posts_order]',
    array(
        'default'           => $newsberry_default['author_posts_order'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[author_posts_order]',
    array(
        'label'       => __( 'Order', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'asc' => __('ASC', 'newsberry'),
            'desc' => __('DESC', 'newsberry'),
        ),
    )
);



$wp_customize->add_setting(
    'newsberry_options[enable_author_posts_author_meta]',
    array(
        'default'           => $newsberry_default['enable_author_posts_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_author_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_posts_author_meta]',
    array(
        'default'           => $newsberry_default['select_author_posts_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => newsberry_author_meta(),


    )
);

$wp_customize->add_setting(
    'newsberry_options[author_posts_author_meta_title]',
    array(
        'default'           => $newsberry_default['author_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[author_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'newsberry' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_author_posts_date_meta]',
    array(
        'default'           => $newsberry_default['enable_author_posts_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_author_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_posts_date]',
    array(
        'default'           => $newsberry_default['select_author_posts_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_posts_date]',
    array(
        'label'         => esc_html__( 'Select Posted on Date Meta', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => newsberry_date_meta(),

    )
);

$wp_customize->add_setting(
    'newsberry_options[single_related_post_date_meta_title]',
    array(
        'default'           => $newsberry_default['single_related_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[single_related_post_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'newsberry' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_posts_date_format]',
    array(
        'default'           => $newsberry_default['select_author_posts_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => newsberry_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_author_posts_category_meta]',
    array(
        'default'           => $newsberry_default['enable_author_posts_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_author_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_posts_number_of_category]',
    array(
        'default'           => $newsberry_default['select_author_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'newsberry' ),
        'section'     => 'single_related_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'newsberry_options[author_posts_category_label]',
    array(
        'default'           => $newsberry_default['author_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[author_posts_category_label]',
    array(
        'label'    => __( 'Category Label', 'newsberry' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_posts_category_color]',
    array(
        'default'           => $newsberry_default['select_author_posts_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'newsberry' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => newsberry_category_color(),

    )
);
