<?php
$wp_customize->add_section(
   'search_latest_post_options' ,
    array(
        'title' => __( 'Search Section Trending Post Options', 'newsberry' ),
        'panel' => 'header_options_panel',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_search_latest_posts]',
    array(
        'default'           => $newsberry_default['enable_search_latest_posts'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_search_latest_posts]',
    array(
		'label'    => __( 'Enable Trending', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_search_latest_label]',
    array(
        'default'           => $newsberry_default['enable_search_latest_label'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_search_latest_label]',
    array(
		'label'           => __( 'Enable Trending Label', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

// Trending Label Text.
$wp_customize->add_setting(
    'newsberry_options[search_latest_label_text]',
    array(
        'default'           => $newsberry_default['search_latest_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[search_latest_label_text]',
    array(
        'label'           => __( 'Trending Label Text', 'newsberry' ),
        'section'         => 'search_latest_post_options',
        'type'            => 'text',
    )
);

// Trending Posts Category.
$wp_customize->add_setting(
	'newsberry_options[search_latest_posts_cat]',
	array(
		'default'           => $newsberry_default['search_latest_posts_cat'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new Newsberry_Dropdown_Taxonomies_Control(
		$wp_customize,
		'newsberry_options[search_latest_posts_cat]',
		array(
			'label'           => __( 'Choose Trending posts category', 'newsberry' ),
			'section'         => 'search_latest_post_options',
		)
	)
);

// No of posts.
$wp_customize->add_setting(
	'newsberry_options[no_of_search_latest_posts]',
	array(
		'default'           => $newsberry_default['no_of_search_latest_posts'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'newsberry_options[no_of_search_latest_posts]',
	array(
		'label'           => __( 'Number of Posts', 'newsberry' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'number',
	)
);

// Posts Orderby.
$wp_customize->add_setting(
	'newsberry_options[search_latest_posts_orderby]',
	array(
		'default'           => $newsberry_default['search_latest_posts_orderby'],
		'sanitize_callback' => 'newsberry_sanitize_select',
	)
);
$wp_customize->add_control(
	'newsberry_options[search_latest_posts_orderby]',
	array(
		'label'           => __( 'Orderby', 'newsberry' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'newsberry' ),
			'id'    => __( 'ID', 'newsberry' ),
			'title' => __( 'Title', 'newsberry' ),
			'rand'  => __( 'Random', 'newsberry' ),
		),
	)
);

// Posts Order.
$wp_customize->add_setting(
	'newsberry_options[search_latest_posts_order]',
	array(
		'default'           => $newsberry_default['search_latest_posts_order'],
		'sanitize_callback' => 'newsberry_sanitize_select',
	)
);
$wp_customize->add_control(
	'newsberry_options[search_latest_posts_order]',
	array(
		'label'           => __( 'Order', 'newsberry' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'newsberry' ),
			'desc' => __( 'DESC', 'newsberry' ),
		),
	)
);


$wp_customize->add_setting(
    'newsberry_options[enable_search_latest_posts_author_meta]',
    array(
        'default'           => $newsberry_default['enable_search_latest_posts_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_search_latest_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Display Author Meta', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_search_latest_posts_author_meta]',
    array(
        'default'           => $newsberry_default['select_search_latest_posts_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_search_latest_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Select Author Meta', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => newsberry_author_meta(),


    )
);

$wp_customize->add_setting(
    'newsberry_options[search_latest_posts_author_meta_title]',
    array(
        'default'           => $newsberry_default['search_latest_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[search_latest_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'newsberry' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_search_latest_posts_date_meta]',
    array(
        'default'           => $newsberry_default['enable_search_latest_posts_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_search_latest_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_search_latest_posts_date]',
    array(
        'default'           => $newsberry_default['select_search_latest_posts_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_search_latest_posts_date]',
    array(
        'label'         => esc_html__( 'Select Posted on Date Meta', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => newsberry_date_meta(),

    )
);

$wp_customize->add_setting(
    'newsberry_options[single_search_latest_post_date_meta_title]',
    array(
        'default'           => $newsberry_default['single_search_latest_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[single_search_latest_post_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'newsberry' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_search_latest_posts_date_format]',
    array(
        'default'           => $newsberry_default['select_search_latest_posts_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_search_latest_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => newsberry_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_search_latest_posts_category_meta]',
    array(
        'default'           => $newsberry_default['enable_search_latest_posts_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_search_latest_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_search_latest_posts_number_of_category]',
    array(
        'default'           => $newsberry_default['select_search_latest_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_search_latest_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'newsberry_options[search_latest_posts_category_label]',
    array(
        'default'           => $newsberry_default['search_latest_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[search_latest_posts_category_label]',
    array(
        'label'       => esc_html__( 'Category Label', 'newsberry' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_search_latest_posts_category_color]',
    array(
        'default'           => $newsberry_default['select_search_latest_posts_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_search_latest_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'newsberry' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => newsberry_category_color(),

    )
);