<?php
/**
 * All settings related to preloader.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'preloader_options',
	array(
		'title' => esc_html__( 'Preloader Options', 'newsberry' ),
		'panel' => 'general_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_preloader_options]',
    array(
        'default'           => $newsberry_default['enable_preloader_options'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_preloader_options]',
    array(
        'label'       => esc_html__( 'Enable Preloader Option', 'newsberry' ),
        'section'     => 'preloader_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[newsberry_preloader_style]',
    array(
        'default'           => $newsberry_default['newsberry_preloader_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[newsberry_preloader_style]',
    array(
        'label'         => esc_html__( 'Select Preloader Style', 'newsberry' ),
        'section'     => 'preloader_options',
        'type'        => 'select',
        'choices'       => newsberry_preloader_style_option(),

    )
);
