<?php
// Popular Posts Options.
$wp_customize->add_section(
    'home_page_popular_post_options',
    array(
        'title' => __('Popular Section', 'newsberry'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_posts]',
    array(
        'default' => $newsberry_default['enable_popular_posts'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_posts]',
    array(
        'label' => __('Enable Popular', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
// Popular Posts Category.
$wp_customize->add_setting(
    'newsberry_options[popular_post_cat]',
    array(
        'default' => $newsberry_default['popular_post_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[popular_post_cat]',
        array(
            'label' => __('Choose Popular posts category', 'newsberry'),
            'section' => 'home_page_popular_post_options',
        )
    )
);
// No of posts.
$wp_customize->add_setting(
    'newsberry_options[no_of_popular_posts]',
    array(
        'default' => $newsberry_default['no_of_popular_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[no_of_popular_posts]',
    array(
        'label' => __('Number of Posts', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);
// Posts Orderby.
$wp_customize->add_setting(
    'newsberry_options[popular_post_orderby]',
    array(
        'default' => $newsberry_default['popular_post_orderby'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[popular_post_orderby]',
    array(
        'label' => __('Orderby', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'newsberry'),
            'id' => __('ID', 'newsberry'),
            'title' => __('Title', 'newsberry'),
            'rand' => __('Random', 'newsberry'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'newsberry_options[popular_post_order]',
    array(
        'default' => $newsberry_default['popular_post_order'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[popular_post_order]',
    array(
        'label' => __('Order', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'newsberry'),
            'desc' => __('DESC', 'newsberry'),
        ),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_author_meta]',
    array(
        'default' => $newsberry_default['enable_popular_post_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_popular_post_author_meta]',
    array(
        'default' => $newsberry_default['select_popular_post_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => newsberry_author_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[popular_post_author_meta_title]',
    array(
        'default' => $newsberry_default['popular_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[popular_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_date_meta]',
    array(
        'default' => $newsberry_default['enable_popular_post_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_popular_post_date]',
    array(
        'default' => $newsberry_default['select_popular_post_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_date]',
    array(
        'label' => esc_html__('Select Posted on Date Meta', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => newsberry_date_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_popular_post_date_meta_title]',
    array(
        'default' => $newsberry_default['select_popular_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_date_meta_title]',
    array(
        'label' => __('Date Text', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_popular_post_date_format]',
    array(
        'default' => $newsberry_default['select_popular_post_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => newsberry_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_category_meta]',
    array(
        'default' => $newsberry_default['enable_popular_post_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_popular_post_number_of_category]',
    array(
        'default' => $newsberry_default['select_popular_post_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_number_of_category]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'newsberry_options[popular_post_category_label]',
    array(
        'default' => $newsberry_default['popular_post_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[popular_post_category_label]',
    array(
        'label' => __('Category Label', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_popular_post_category_color]',
    array(
        'default' => $newsberry_default['select_popular_post_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_popular_post_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => newsberry_category_color(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[popular_post_column]',
    array(
        'default' => $newsberry_default['popular_post_column'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[popular_post_column]',
    array(
        'label' => __('Popular Post Column', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            '2' => __('2', 'newsberry'),
            '3' => __('3', 'newsberry'),
            '4' => __('4', 'newsberry'),
            '5' => __('5', 'newsberry'),
        ),
        'active_callback' => 'newsberry_is_popular_post_enabled',
    )
);
// Enable  Autoplay.
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_autoplay]',
    array(
        'default' => $newsberry_default['enable_popular_post_autoplay'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_autoplay]',
    array(
        'label' => __('Enable Autoplay', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'newsberry_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_arrows]',
    array(
        'default' => $newsberry_default['enable_popular_post_arrows'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_arrows]',
    array(
        'label' => __('Enable Arrows', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'newsberry_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_popular_post_dots]',
    array(
        'default' => $newsberry_default['enable_popular_post_dots'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_popular_post_dots]',
    array(
        'label' => __('Enable Dots', 'newsberry'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'newsberry_is_popular_post_enabled',
    )
);
