<?php
$wp_customize->add_section(
   'mobile_menu_options' ,
    array(
        'title' => __( 'Mobile Menu Options', 'newsberry' ),
        'panel' => 'header_options_panel',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_social_mobile_menu]',
    array(
        'default'           => $newsberry_default['enable_social_mobile_menu'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_social_mobile_menu]',
    array(
        'label'         => esc_html__( 'Social Menu to Display in Mobile', 'newsberry' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_mobile_social_menu_style]',
    array(
        'default'           => $newsberry_default['select_mobile_social_menu_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_mobile_social_menu_style]',
    array(
        'label'         => esc_html__( 'Social Menu Options', 'newsberry' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'select',
        'choices'       => newsberry_social_menu_style(),


    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_mobile_social_nav_border_radius]',
    array(
        'default'           => $newsberry_default['enable_mobile_social_nav_border_radius'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_mobile_social_nav_border_radius]',
    array(
        'label'    => __( 'Enable Border Radius', 'newsberry' ),
        'section'  => 'mobile_menu_options',
        'type'     => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_copyright_in_menu]',
    array(
        'default'           => $newsberry_default['enable_copyright_in_menu'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_copyright_in_menu]',
    array(
        'label'         => esc_html__( 'Copyright in Mobile', 'newsberry' ),
        'section'     => 'mobile_menu_options',
        'type'        => 'checkbox',
    )
);


