<?php
/**
 * All settings related to main banner post.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'main_banner_post',
	array(
		'title' => esc_html__( 'Main Banner Section', 'newsberry' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_main_banner_section]',
    array(
        'default'           => $newsberry_default['enable_main_banner_section'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_main_banner_section]',
    array(
        'label'       => esc_html__( 'Enable Main Banner', 'newsberry' ),
        'section'     => 'main_banner_post',
        'type'        => 'checkbox',
    )
);



$wp_customize->add_setting(
    'newsberry_section_seperator_banner_column_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_banner_column_1',
        array(
            'label'         => esc_html__( 'Banner Column - 1', 'newsberry' ),
            'settings' => 'newsberry_section_seperator_banner_column_1',
            'section' => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[banner_grid_post_category]',
    array(
        'default'           => $newsberry_default['banner_grid_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[banner_grid_post_category]',
        array(
            'label'           => __( 'Choose Grid Category', 'newsberry' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'newsberry' ),
            'section'         => 'main_banner_post',
        )
    )
);




$wp_customize->add_setting(
    'newsberry_section_seperator_banner_column_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_banner_column_2',
        array(
            'label'         => esc_html__( 'Banner Column - 2', 'newsberry' ),
            'settings' => 'newsberry_section_seperator_banner_column_2',
            'section' => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[banner_list_post_title]',
    array(
        'default'           => $newsberry_default['banner_list_post_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[banner_list_post_title]',
    array(
        'label'    => __( 'Banner List Post', 'newsberry' ),
        'section'  => 'main_banner_post',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[banner_list_post_category]',
    array(
        'default'           => $newsberry_default['banner_list_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[banner_list_post_category]',
        array(
            'label'           => __( 'Choose List Post Category', 'newsberry' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'newsberry' ),
            'section'         => 'main_banner_post',
        )
    )
);





$wp_customize->add_setting(
    'newsberry_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Banner Section Meta', 'newsberry' ),
            'settings' => 'newsberry_section_seperator_banner',
            'section' => 'main_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_banner_author_meta]',
    array(
        'default' => $newsberry_default['enable_banner_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_author_meta]',
    array(
        'default' => $newsberry_default['select_banner_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => newsberry_author_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[banner_author_meta_title]',
    array(
        'default' => $newsberry_default['banner_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[banner_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_banner_date_meta]',
    array(
        'default' => $newsberry_default['enable_banner_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_date]',
    array(
        'default' => $newsberry_default['select_banner_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_date]',
    array(
        'label' => esc_html__('Select Posted on Date Meta', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => newsberry_date_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_date_meta_title]',
    array(
        'default' => $newsberry_default['select_banner_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_date_meta_title]',
    array(
        'label' => __('Date Text', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_date_format]',
    array(
        'default' => $newsberry_default['select_banner_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => newsberry_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_banner_category_meta]',
    array(
        'default' => $newsberry_default['enable_banner_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_number_of_category]',
    array(
        'default' => $newsberry_default['select_banner_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_number_of_category]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'newsberry_options[banner_category_label]',
    array(
        'default' => $newsberry_default['banner_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[banner_category_label]',
    array(
        'label' => __('Category Label', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_banner_category_color]',
    array(
        'default' => $newsberry_default['select_banner_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'newsberry'),
        'section' => 'main_banner_post',
        'type' => 'select',
        'choices' => newsberry_category_color(),
    )
);