<?php
$wp_customize->add_section(
   'header_style_options' ,
    array(
        'title' => __( 'Header Layout', 'newsberry' ),
        'panel' => 'header_options_panel',
    )
);


$wp_customize->add_setting(
    'newsberry_options[select_header_layout_style]',
    array(
        'default'           => $newsberry_default['select_header_layout_style'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[select_header_layout_style]',
        array(
            'label'         => esc_html__( 'Select Header Layout', 'newsberry' ),
            'section'       => 'header_style_options',
            'choices'       => newsberry_get_header_layout(),
        )
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_header_advertisement]',
    array(
        'default'           => $newsberry_default['enable_header_advertisement'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_header_advertisement]',
    array(
        'label'    => __( 'Enable Header Advertisement', 'newsberry' ),
        'section'     => 'header_style_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[header_advert_image]',
    array(
        'default' => $newsberry_default['header_advert_image'],
        'sanitize_callback' => 'newsberry_sanitize_image',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'newsberry_options[header_advert_image]',
        array(
            'label' => __('Upload Banner Advertisement', 'newsberry'),
            'section' => 'header_style_options',
            'active_callback' => 'newsberry_header_advertisement',

        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[header_advert_image_url]',
    array(
        'default'           => $newsberry_default['header_advert_image_url'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    'newsberry_options[header_advert_image_url]',
    array(
        'label'    => __( 'Banner Advertisement URL', 'newsberry' ),
        'section'  => 'header_style_options',
        'type'     => 'text',
        'active_callback' => 'newsberry_header_advertisement',

    )
);