<?php
// Frontline Posts Options.
$wp_customize->add_section(
    'home_page_frontline_options',
    array(
        'title' => __('Frontline Section', 'newsberry'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_frontlines]',
    array(
        'default' => $newsberry_default['enable_frontlines'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_frontlines]',
    array(
        'label' => __('Enable Frontline', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);

// Frontline Posts Category.
$wp_customize->add_setting(
    'newsberry_options[frontline_cat]',
    array(
        'default' => $newsberry_default['frontline_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[frontline_cat]',
        array(
            'label' => __('Choose Frontline category', 'newsberry'),
            'section' => 'home_page_frontline_options',
        )
    )
);
$wp_customize->add_setting(
    'newsberry_options[frontline_layout_style]',
    array(
        'default' => $newsberry_default['frontline_layout_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[frontline_layout_style]',
    array(
        'label' => __('Select Layout Style', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'frontline-layout-1' => __('Layout - 1', 'newsberry'),
            'frontline-layout-2' => __('Layout - 2', 'newsberry'),
            'frontline-layout-3' => __('Layout - 3', 'newsberry'),
        ),
    )
);
// No of posts.
$wp_customize->add_setting(
    'newsberry_options[no_of_frontlines]',
    array(
        'default' => $newsberry_default['no_of_frontlines'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[no_of_frontlines]',
    array(
        'label' => __('Number of Posts', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
// Posts Orderby.
$wp_customize->add_setting(
    'newsberry_options[frontline_orderby]',
    array(
        'default' => $newsberry_default['frontline_orderby'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[frontline_orderby]',
    array(
        'label' => __('Orderby', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'newsberry'),
            'id' => __('ID', 'newsberry'),
            'title' => __('Title', 'newsberry'),
            'rand' => __('Random', 'newsberry'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'newsberry_options[frontline_order]',
    array(
        'default' => $newsberry_default['frontline_order'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[frontline_order]',
    array(
        'label' => __('Order', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'newsberry'),
            'desc' => __('DESC', 'newsberry'),
        ),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_frontline_author_meta]',
    array(
        'default' => $newsberry_default['enable_frontline_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_frontline_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_frontline_author_meta]',
    array(
        'default' => $newsberry_default['select_frontline_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => newsberry_author_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[frontline_author_meta_title]',
    array(
        'default' => $newsberry_default['frontline_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[frontline_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_frontline_date_meta]',
    array(
        'default' => $newsberry_default['enable_frontline_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_frontline_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_frontline_date]',
    array(
        'default' => $newsberry_default['select_frontline_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_date]',
    array(
        'label' => esc_html__('Select Posted on Date Meta', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => newsberry_date_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_frontline_date_meta_title]',
    array(
        'default' => $newsberry_default['select_frontline_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_date_meta_title]',
    array(
        'label' => __('Date Text', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_frontline_date_format]',
    array(
        'default' => $newsberry_default['select_frontline_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => newsberry_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_frontline_category_meta]',
    array(
        'default' => $newsberry_default['enable_frontline_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_frontline_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_frontline_number_of_category]',
    array(
        'default' => $newsberry_default['select_frontline_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_number_of_category]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'newsberry_options[frontline_category_label]',
    array(
        'default' => $newsberry_default['frontline_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[frontline_category_label]',
    array(
        'label' => __('Category Label', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_frontline_category_color]',
    array(
        'default' => $newsberry_default['select_frontline_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_frontline_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'newsberry'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => newsberry_category_color(),
    )
);
