<?php
// Popular Posts Options.
$wp_customize->add_section(
    'footer_section_options',
    array(
        'title' => __('Footer Copyright Options', 'newsberry'),
        'panel' => 'footer_options_panel',
    )
);


/*Copyright Text.*/
$wp_customize->add_setting('newsberry_options[copyright_text]'
    ,
    array(
        'default'           => $newsberry_default['copyright_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('newsberry_options[copyright_text]'
    ,
    array(
        'label'           => __( 'Copyright Text', 'newsberry' ),
        'description'     => __( 'Use {{ date }} to get the current date.', 'newsberry' ),
        'section'         => 'footer_section_options',
        'type'            => 'text',
    )
);

/*Copyright Date Format*/
$wp_customize->add_setting(
    'newsberry_options[copyright_date_format]',
    array(
        'default'           => $newsberry_default['copyright_date_format'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[copyright_date_format]',
    array(
        'label'           => __( 'Copyright Date Format', 'newsberry' ),
        'description'     => sprintf(
            wp_kses(
                __( '<a href="%s" target="_blank">Date and Time Formatting Documentation</a>.', 'newsberry' ),
                array(
                    'a' => array(
                        'href'   => array(),
                        'target' => array(),
                    ),
                )
            ),
            esc_url( 'https://wordpress.org/support/article/formatting-date-and-time' )
        ),
        'section'         => 'footer_section_options',
        'type'            => 'text',
    )
);
/*Enable Footer Nav*/
$wp_customize->add_setting(
    'newsberry_options[enable_footer_nav]',
    array(
        'default'           => $newsberry_default['enable_footer_nav'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_footer_nav]',
    array(
        'label'       => __( 'Show Footer Nav Menu', 'newsberry' ),
        'description' => sprintf( __( 'You can add/edit footer nav menu from <a href="%s">here</a>.', 'newsberry' ), "javascript:wp.customize.control( 'nav_menu_locations[footer]' ).focus();" ),
        'section'     => 'footer_section_options',
        'type'     => 'checkbox',
    )
);


/*Enable Footer Social Nav*/

$wp_customize->add_setting(
    'newsberry_options[enable_footer_social_nav]',
    array(
        'default'           => $newsberry_default['enable_footer_social_nav'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_footer_social_nav]',
    array(
        'label'       => __( 'Show Social Nav Menu in Footer', 'newsberry' ),
        'description' => sprintf( __( 'You can add/edit social nav menu from <a href="%s">here</a>.', 'newsberry' ), "javascript:wp.customize.control( 'nav_menu_locations[social]' ).focus();" ),
        'section'     => 'footer_section_options',
        'type'     => 'checkbox',
    )
);



$wp_customize->add_setting(
    'newsberry_options[select_footer_social_menu_style]',
    array(
        'default'           => $newsberry_default['select_footer_social_menu_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_footer_social_menu_style]',
    array(
        'label'         => esc_html__( 'Social Menu Options', 'newsberry' ),
        'section'     => 'footer_section_options',
        'type'        => 'select',
        'choices'       => newsberry_social_menu_style(),


    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_footer_social_nav_border_radius]',
    array(
        'default'           => $newsberry_default['enable_footer_social_nav_border_radius'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_footer_social_nav_border_radius]',
    array(
        'label'    => __( 'Enable Border Radius', 'newsberry' ),
        'section'  => 'footer_section_options',
        'type'     => 'checkbox',
    )
);

// Popular Posts Options.
$wp_customize->add_section(
    'footer_scroll_to_top_options',
    array(
        'title' => __('Footer Scroll To Top', 'newsberry'),
        'panel' => 'footer_options_panel',
    )
);


/*Copyright Text.*/
$wp_customize->add_setting('newsberry_options[enable_footer_scroll_to_top]'
    ,
    array(
        'default'           => $newsberry_default['enable_footer_scroll_to_top'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
        
    )
);
$wp_customize->add_control('newsberry_options[enable_footer_scroll_to_top]'
    ,
    array(
        'label'           => __( 'Enable Footer Scroll To Top', 'newsberry' ),
        'section'         => 'footer_scroll_to_top_options',
        'type'            => 'checkbox',
    )
);


// Popular Posts Options.
$wp_customize->add_section(
    'footer_progressbar_options',
    array(
        'title' => __('Footer ProgressBar', 'newsberry'),
        'panel' => 'footer_options_panel',
    )
);


/*Copyright Text.*/
$wp_customize->add_setting('newsberry_options[enable_footer_progressbar]'
    ,
    array(
        'default'           => $newsberry_default['enable_footer_progressbar'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',

    )
);
$wp_customize->add_control('newsberry_options[enable_footer_progressbar]'
    ,
    array(
        'label'           => __( 'Enable Footer ProgressBar', 'newsberry' ),
        'description'     => __( 'Screen Progressbar enable option', 'newsberry' ),
        'section'         => 'footer_progressbar_options',
        'type'            => 'checkbox',
    )
);

