<?php
// footer widget Options.
$wp_customize->add_section(
    'footer_widget_section',
    array(
        'title' => __('Footer Widget Options', 'newsberry'),
        'panel' => 'footer_options_panel',
    )
);



/*Enable Footer Nav*/
$wp_customize->add_setting(
    'newsberry_options[enable_footer_widget]',
    array(
        'default'           => $newsberry_default['enable_footer_widget'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_footer_widget]',
    array(
        'label'       => __( 'Show Footer widgetarea', 'newsberry' ),
        'section'     => 'footer_widget_section',
        'type'     => 'checkbox',
    )
);

// Option to choose footer column layout.
$wp_customize->add_setting(
	'newsberry_options[footer_column_layout]',
	array(
		'default'           => $newsberry_default['footer_column_layout'],
		'sanitize_callback' => 'newsberry_sanitize_radio',
	)
);
$wp_customize->add_control(
	new Newsberry_Custom_Radio_Image_Control(
		$wp_customize,
		'newsberry_options[footer_column_layout]',
		array(
			'label'       => __( 'Footer Column Layout', 'newsberry' ),
			'description' => __( 'Some footer widgetareas will not be used based on the footer column layout chosen. Also make sure to insert at least one widget on the respective widgetarea for it to display.', 'newsberry' ),
			'section'     => 'footer_widget_section',
			'choices'     => newsberry_get_footer_layouts(),
			'priority'    => 40,
		)
	)
);
