<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'footer_recommended_post',
	array(
		'title' => esc_html__( 'Recommended Section', 'newsberry' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_recommended_post]',
    array(
        'default'           => $newsberry_default['enable_recommended_post'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_recommended_post]',
    array(
        'label'       => esc_html__( 'Enable Recommended Post', 'newsberry' ),
        'section'     => 'footer_recommended_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[recommended_post_layout]',
    array(
        'default'           => $newsberry_default['recommended_post_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);


$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[recommended_post_layout]',
        array(
            'label'         => esc_html__( 'Recommended Post Layout', 'newsberry' ),
            'section'       => 'footer_recommended_post',
            'choices'       => newsberry_get_recommended_post(),
        )
    )
);



$wp_customize->add_setting(
    'newsberry_options[recommended_post_title]',
    array(
        'default'           => $newsberry_default['recommended_post_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[recommended_post_title]',
    array(
        'label'    => __( 'Recommended Post', 'newsberry' ),
        'section'  => 'footer_recommended_post',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[recommended_post_category]',
    array(
        'default'           => $newsberry_default['recommended_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[recommended_post_category]',
        array(
            'label'           => __( 'Choose Category', 'newsberry' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'newsberry' ),
            'section'         => 'footer_recommended_post',
        )
    )
);









$wp_customize->add_setting(
    'newsberry_options[enable_recommended_post_author_meta]',
    array(
        'default' => $newsberry_default['enable_recommended_post_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_author_meta]',
    array(
        'default' => $newsberry_default['select_recommended_post_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => newsberry_author_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[recommended_post_author_meta_title]',
    array(
        'default' => $newsberry_default['recommended_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[recommended_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_recommended_post_date_meta]',
    array(
        'default' => $newsberry_default['enable_recommended_post_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_recommended_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_date]',
    array(
        'default' => $newsberry_default['select_recommended_post_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_date]',
    array(
        'label' => esc_html__('Select Posted on Date Meta', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => newsberry_date_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_date_meta_title]',
    array(
        'default' => $newsberry_default['select_recommended_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_date_meta_title]',
    array(
        'label' => __('Date Text', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_date_format]',
    array(
        'default' => $newsberry_default['select_recommended_post_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => newsberry_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_recommended_post_category_meta]',
    array(
        'default' => $newsberry_default['enable_recommended_post_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_recommended_post_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_number_of_category]',
    array(
        'default' => $newsberry_default['select_recommended_post_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_number_of_category]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'newsberry_options[recommended_post_category_label]',
    array(
        'default' => $newsberry_default['recommended_post_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[recommended_post_category_label]',
    array(
        'label' => __('Category Label', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_recommended_post_category_color]',
    array(
        'default' => $newsberry_default['select_recommended_post_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_recommended_post_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'newsberry'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => newsberry_category_color(),
    )
);