<?php
/**
 * All settings related to Featured Category.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'featured_category',
	array(
		'title' => esc_html__( 'Category Section', 'newsberry' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_featured_category]',
    array(
        'default'           => $newsberry_default['enable_featured_category'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_featured_category]',
    array(
        'label'       => esc_html__( 'Enable Featured Category', 'newsberry' ),
        'section'     => 'featured_category',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[featured_category_title]',
    array(
        'default'           => $newsberry_default['featured_category_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[featured_category_title]',
    array(
        'label'    => __( 'Featured Category', 'newsberry' ),
        'section'  => 'featured_category',
        'type'     => 'text',
    )
);

for ($i=1; $i <=4 ; $i++) { 
    $wp_customize->add_setting(
    'newsberry_options[featured_category_'.$i.']',
    array(
        'default'           => '',
        'sanitize_callback' => 'absint',
    )
    );
    $wp_customize->add_control(
        new Newsberry_Dropdown_Taxonomies_Control(
            $wp_customize,
            'newsberry_options[featured_category_'.$i.']',
            array(
                'label'           => __( 'Choose Category -', 'newsberry' ).$i,
                'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'newsberry' ),
                'section'         => 'featured_category',
            )
        )
    );
}

