<?php
$wp_customize->add_section(
    'pagination_options',
    array(
        'title' => esc_html__( 'Pagination Options', 'newsberry' ),
        'panel' => 'archive_options_panel',
    )
);


$wp_customize->add_setting(
    'newsberry_options[select_pagination_style]',
    array(
        'default'           => $newsberry_default['select_pagination_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_pagination_style]',
    array(
        'label'         => esc_html__( 'Select Pagination Style', 'newsberry' ),
        'section'     => 'pagination_options',
        'type'        => 'select',
        'choices'       => newsberry_pagination_style_choice(),

    )
);


$wp_customize->add_section(
    'excerpt_options',
    array(
        'title' => esc_html__( 'Excerpt Options', 'newsberry' ),
        'panel' => 'archive_options_panel',
    )
);

$wp_customize->add_setting(
    'newsberry_options[number_of_word_in_excerpt]',
    array(
        'default'           => $newsberry_default['number_of_word_in_excerpt'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[number_of_word_in_excerpt]',
    array(
        'label'         => esc_html__( 'Number Of Excerpt Word', 'newsberry' ),
        'section'     => 'excerpt_options',
        'type'        => 'number',

    )
);


$wp_customize->add_setting(
    'newsberry_options[excerpt_posts_title_limit]',
    array(
        'default'           => $newsberry_default['excerpt_posts_title_limit'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[excerpt_posts_title_limit]',
    array(
        'label'    => __( 'Excerpt Line Limit', 'newsberry' ),
        'section'  => 'excerpt_options',
        'type'     => 'select',
        'choices'  => newsberry_line_limit_choices(),
    )
);

$wp_customize->add_setting(
    'newsberry_options[archive_excerpt_button_text]',
    array(
        'default'           => $newsberry_default['archive_excerpt_button_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[archive_excerpt_button_text]',
    array(
        'label'    => __( 'Excerpt Button Text', 'newsberry' ),
        'section'  => 'excerpt_options',
        'type'     => 'text',
    )
);