<?php
/**
 * All settings related to archive.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'archive_options',
	array(
		'title' => esc_html__( 'Archive Options', 'newsberry' ),
		'panel' => 'archive_options_panel',
	)
);

// Archive Layout.
$wp_customize->add_setting(
    'newsberry_options[archive_layout]',
    array(
        'default'           => $newsberry_default['archive_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[archive_layout]',
        array(
            'label'         => esc_html__( 'Archive Layout', 'newsberry' ),
            'section'       => 'archive_options',
            'choices'       => newsberry_get_archive_layouts(),
        )
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_archive_featured_post]',
    array(
        'default'           => $newsberry_default['enable_archive_featured_post'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_archive_featured_post]',
    array(
        'label'    => __( 'Enable Featured Post', 'newsberry' ),
        'description' => __( 'After enabling, set \'Mark as Featured\' to \'Yes\' in the single post options to display the post in the top section of the relevant archive page.', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);

$wp_customize->add_setting(
    'newsberry_section_seperator_archive_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_archive_1',
        array(
            'label'         => esc_html__( 'Archive Meta Options', 'newsberry' ),
            'settings' => 'newsberry_section_seperator_archive_1',
            'section' => 'archive_options',
        )
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_archive_post_count]',
    array(
        'default'           => $newsberry_default['enable_archive_post_count'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_archive_post_count]',
    array(
        'label'    => __( 'Enable Archive Post Count', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',

    )
);


$wp_customize->add_setting(
    'newsberry_options[archive_posts_title_limit]',
    array(
        'default'           => $newsberry_default['archive_posts_title_limit'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[archive_posts_title_limit]',
    array(
        'label'    => __( 'Title Line Limit', 'newsberry' ),
        'section'  => 'archive_options',
        'type'     => 'select',
        'choices'  => newsberry_line_limit_choices(),
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_excerpt_on_archive_1]',
    array(
        'default'           => $newsberry_default['enable_excerpt_on_archive_1'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_excerpt_on_archive_1]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'newsberry_is_archive_excerpt_callbac_1',

    )
);



$wp_customize->add_setting(
    'newsberry_options[enable_excerpt_on_archive_2]',
    array(
        'default'           => $newsberry_default['enable_excerpt_on_archive_2'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_excerpt_on_archive_2]',
    array(
        'label'    => __( 'Enable Excerpt On Archive', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
        'active_callback' => 'newsberry_is_archive_excerpt_callbac_2',
        
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_archive_author_meta]',
    array(
        'default'           => $newsberry_default['enable_archive_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_archive_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_author_meta]',
    array(
        'default'           => $newsberry_default['select_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => newsberry_author_meta(),
        'active_callback' => 'newsberry_is_archive_author_meta_enabled',


    )
);

$wp_customize->add_setting(
    'newsberry_options[archive_author_meta_title]',
    array(
        'default'           => $newsberry_default['archive_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[archive_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'newsberry' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                newsberry_is_archive_author_meta_enabled( $control )
                &&
                newsberry_archive_author_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_archive_date_meta]',
    array(
        'default'           => $newsberry_default['enable_archive_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_archive_date_meta]',
    array(
        'label'       => esc_html__( 'Show Date Meta', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_archive_date]',
    array(
        'default'           => $newsberry_default['select_archive_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_archive_date]',
    array(
        'label'         => esc_html__( 'Date Meta Display Options', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'       => newsberry_date_meta(),
        'active_callback' => 'newsberry_is_archive_date_meta_enabled',

    )
);

$wp_customize->add_setting(
    'newsberry_options[archive_date_meta_title]',
    array(
        'default'           => $newsberry_default['archive_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[archive_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'newsberry' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => function ( $control ) {
            return (
                newsberry_is_archive_date_meta_enabled( $control )
                &&
                newsberry_archive_date_meta_title( $control )
            );
        },
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_date_format]',
    array(
        'default'           => $newsberry_default['select_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> newsberry_get_date_formats(),
        'active_callback' => 'newsberry_is_archive_date_meta_enabled',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_category_meta]',
    array(
        'default'           => $newsberry_default['enable_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[number_of_category_to_display]',
    array(
        'default' => $newsberry_default['number_of_category_to_display'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[number_of_category_to_display]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'archive_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'newsberry_options[archive_category_label]',
    array(
        'default'           => $newsberry_default['archive_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[archive_category_label]',
    array(
        'label'    => __( 'Category Title', 'newsberry' ),
        'section'  => 'archive_options',
        'type'     => 'text',
        'active_callback' => 'newsberry_is_archive_category_meta_enabled',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_category_color]',
    array(
        'default'           => $newsberry_default['select_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'select',
        'choices'  		=> newsberry_category_color(),
        'active_callback' => 'newsberry_is_archive_category_meta_enabled',

    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_tag_meta]',
    array(
        'default'           => $newsberry_default['enable_tag_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_comment_meta]',
    array(
        'default'           => $newsberry_default['enable_comment_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_comment_meta]',
    array(
        'label'       => esc_html__( 'Enable Comment Meta', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_read_time_meta]',
    array(
        'default'           => $newsberry_default['enable_read_time_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'newsberry' ),
        'section'     => 'archive_options',
        'type'        => 'checkbox',
    )
);
