<?php
if (!function_exists('newsberry_get_option')) :
    /**
     * Get customizer value by key.
     *
     * @param string $key Option key.
     * @return mixed Option value.
     * @since 1.0.0
     *
     */
    function newsberry_get_option($key)
    {
        $key_value = '';
        if (!$key) {
            return $key_value;
        }
        $default_values = newsberry_get_all_customizer_default_values();
        $customizer_values = get_theme_mod('newsberry_options');
        $customizer_values = wp_parse_args($customizer_values, $default_values);

        $key_value = (isset($customizer_values[$key])) ? $customizer_values[$key] : '';
        return $key_value;
    }
endif;

if ( ! function_exists( 'newsberry_get_archive_layouts' ) ) :
	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_archive_layouts() {
		$options = apply_filters(
			'newsberry_get_archive_layouts',
			array(
				'archive_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-1.webp',
					'label' => esc_html__( 'Archive List View', 'newsberry' ),
				),
				'archive_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-2.webp',
					'label' => esc_html__( 'Archive Grid View', 'newsberry' ),
				),
				'archive_style_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-3.webp',
					'label' => esc_html__( 'Archive Alternate Grid View', 'newsberry' ),
				),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_get_date_formats' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_date_formats() {
		$options = apply_filters(
			'newsberry_archive_date_format',
			array(
				'classic'   => __( 'Classic', 'newsberry' ),
				'time_ago' => __( 'Time Ago', 'newsberry' ),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_line_limit_choices' ) ) :
	/**
	 * Returns title limit options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_line_limit_choices() {
		$options = apply_filters(
			'newsberry_title_limit_options',
			array(
				''              => __( '&mdash; No Limit &mdash;', 'newsberry' ),
				'limit-line-1' => __( '1 Line', 'newsberry' ),
				'limit-line-2' => __( '2 Lines', 'newsberry' ),
				'limit-line-3' => __( '3 Lines', 'newsberry' ),
				'limit-line-4' => __( '4 Lines', 'newsberry' ),
				'limit-line-5' => __( '5 Lines', 'newsberry' ),
			)
		);
		return $options;
	}
endif;
if ( ! function_exists( 'newsberry_archive_category_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_archive_category_style() {
		$options = apply_filters(
			'newsberry_archive_category_style',
			array(
				'archive_cat_style_1'   => __( 'Category Style 1', 'newsberry' ),
				'archive_cat_style_2'   => __( 'Category Style 2', 'newsberry' ),
				'archive_cat_style_3'   => __( 'Category Style 3', 'newsberry' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_archive_read_time_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_archive_read_time_style() {
		$options = apply_filters(
			'newsberry_archive_read_time_style',
			array(
				'archive_read_time_style_1'   => __( 'Read Time Style 1', 'newsberry' ),
				'archive_read_time_style_2'   => __( 'Read Time Style 2', 'newsberry' ),
				'archive_read_time_style_3'   => __( 'Read Time Style 3', 'newsberry' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_get_header_layout' ) ) :
	/**
	 * Returns header layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_header_layout() {
		$options = apply_filters(
			'newsberry_get_header_layout',
			array(
				'header_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-1.webp',
					'label' => esc_html__( 'Header Style 1', 'newsberry' ),
				),
				'header_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-2.webp',
					'label' => esc_html__( 'Header Style 2', 'newsberry' ),
				),
                'header_style_3' => array(
                    'url'   => get_template_directory_uri() . '/assets/images/header-3.webp',
                    'label' => esc_html__( 'Header Style 3', 'newsberry' ),
                ),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_social_menu_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_social_menu_style() {
		$options = apply_filters(
			'newsberry_social_menu_style',
			array(
				'has-brand-background'   => __( 'Has Brand Background', 'newsberry' ),
				'has-brand-color'   => __( 'Has Brand Color', 'newsberry' ),
				'none'   => __( 'None', 'newsberry' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_pagination_style_choice' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_pagination_style_choice() {
		$options = apply_filters(
			'newsberry_pagination_style_choice',
			array(
				'pagination_none'   => __( 'None', 'newsberry' ),
				'pagination_numeric'   => __( 'Numeric', 'newsberry' ),
				'pagination_default'   => __( 'Default(New/Old Post)', 'newsberry' ),
				'pagination_ajax_on_scroll'   => __( 'Load More On Scroll', 'newsberry' ),
				'pagination_ajax_on_click'   => __( 'Load More On Click', 'newsberry' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_category_color' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_category_color() {
		$options = apply_filters(
			'newsberry_category_color',
			array(
				'none'   => __( 'None', 'newsberry' ),
				'has-background'   => __( 'Has background', 'newsberry' ),
				'has-text-color'   => __( 'Has text color', 'newsberry' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_get_footer_layouts' ) ) :
	/**
	 * Returns footer layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_footer_layouts() {
		$options = apply_filters(
			'newsberry_footer_layouts',
			array(
				'footer_layout_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-4.webp',
					'label' => esc_html__( 'Four Columns', 'newsberry' ),
				),
				'footer_layout_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3.webp',
					'label' => esc_html__( 'Three Columns', 'newsberry' ),
				),
				'footer_layout_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2.webp',
					'label' => esc_html__( 'Two Columns', 'newsberry' ),
				),
				'footer_layout_4' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-left.webp',
					'label' => esc_html__( 'Two Columns Big Left', 'newsberry' ),
				),
				'footer_layout_5' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3-big-middle.webp',
					'label' => esc_html__( 'Three Columns Big Middle', 'newsberry' ),
				),
				'footer_layout_6' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-right.webp',
					'label' => esc_html__( 'Two Columns Big Right', 'newsberry' ),
				),
				'footer_layout_7' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-1.webp',
					'label' => esc_html__( 'Single Column', 'newsberry' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_preloader_style_option' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_preloader_style_option() {
		$options = apply_filters(
			'newsberry_preloader_style_option',
			array(
				'style-1'   => __( 'Style - 1', 'newsberry' ),
				'style-2'   => __( 'Style - 2', 'newsberry' ),
				'style-3'   => __( 'Style - 3', 'newsberry' ),
				'style-4'   => __( 'Style - 4', 'newsberry' ),
				'style-5'   => __( 'Style - 5', 'newsberry' ),
				'style-6'   => __( 'Style - 6', 'newsberry' ),
				'style-7'   => __( 'Style - 7', 'newsberry' ),
				'style-8'   => __( 'Style - 8', 'newsberry' ),
				'style-9'   => __( 'Style - 9', 'newsberry' ),
				'style-10'   => __( 'Style - 10', 'newsberry' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_get_recommended_post' ) ) :
	/**
	 * Returns recommended layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_recommended_post() {
		$options = apply_filters(
			'newsberry_get_recommended_post',
			array(
				'wpi-post-recommendation-1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-1.webp',
					'label' => esc_html__( 'Recommended List View', 'newsberry' ),
				),
				'wpi-post-recommendation-2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-2.webp',
					'label' => esc_html__( 'Recommended Grid View', 'newsberry' ),
				),
				'wpi-post-recommendation-3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-3.webp',
					'label' => esc_html__( 'Recommended Alternate Grid View', 'newsberry' ),
				),
			)
		);
		return $options;
	}
endif;



if ( ! function_exists( 'newsberry_author_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_author_meta() {
		$options = apply_filters(
			'newsberry_author_meta',
			array(
				'with_label'   => __( 'With Label', 'newsberry' ),
				'with_icon'   => __( 'With Icon', 'newsberry' ),
				'with_avatar_image'   => __( 'With Avatar Image', 'newsberry' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_date_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_date_meta() {
		$options = apply_filters(
			'newsberry_date_meta',
			array(
				'with_label'   => __( 'With Label', 'newsberry' ),
				'with_icon'   => __( 'With Icon', 'newsberry' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'newsberry_get_sidebar_layouts' ) ) :
	/**
	 * Returns general layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_sidebar_layouts() {
		$options = apply_filters(
			'newsberry_sidebar_layouts',
			array(
				'left-sidebar'      => array(
					'url'   => get_template_directory_uri() . '/assets/images/left-sidebar.webp',
					'label' => esc_html__( 'Left Sidebar', 'newsberry' ),
				),
				'right-sidebar'     => array(
					'url'   => get_template_directory_uri() . '/assets/images/right-sidebar.webp',
					'label' => esc_html__( 'Right Sidebar', 'newsberry' ),
				),
				'no-sidebar'        => array(
					'url'   => get_template_directory_uri() . '/assets/images/no-sidebar.webp',
					'label' => esc_html__( 'No Sidebar - Wide', 'newsberry' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'newsberry_get_social_links_styles' ) ) :
	/**
	 * Returns social links styles options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function newsberry_get_social_links_styles() {
		$options = apply_filters(
			'newsberry_social_links_styles',
			array(
				'style_1' => __( 'Style 1', 'newsberry' ),
				'style_2' => __( 'Style 2', 'newsberry' ),
				'style_3' => __( 'Style 3', 'newsberry' ),
				'style_4' => __( 'Style 4', 'newsberry' ),
			)
		);
		return $options;
	}
endif;
