<?php

function newsable_sanitize_select( $input, $setting ) {
	
	// Ensure input is a slug
	$input = sanitize_key( $input );
	
	// Get list of choices from the control
	// associated with the setting
	$choices = $setting->manager->get_control( $setting->id );
	
	// If the input is a valid key, return it;
	// otherwise, return the default
	return ( array_key_exists( $input, $choices->choices ) ? $input : $setting->default );
}



function newsable_layout_customizer_settings( $wp_customize ){



	//INDEX POSTS STYLE
	$wp_customize->add_setting('newsable_index_class_name_settings', array(
	    'default' => __('newsjolt-magazine-index', 'newsable'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'newsable_index_class_name_display_control', array(
	    'label'    => __('Newsable - Change Style', 'newsable'),
	    'section'  => 'newsjolt_magazine_index_class_name_section',
	    'settings' => 'newsable_index_class_name_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-index' 		            => __('List Layout - Right Sidebar', 'newsable'),
	    				'newsjolt-magazine-index-twenty-three' 		=> __('List (box shadow) - Two Columns Right Sidebar - Right Sidebar', 'newsable'),
	    				'newsjolt-magazine-index-twenty-four' 		=> __('List (border) - Two Columns Right Sidebar - Right Sidebar', 'newsable'),
	    			   )
	)));

	//CHANGE STYLE FEATURE SECTION
	$wp_customize->add_setting('newsable_feature_change_style_settings', array(
	    'default' => __('newsjolt-magazine-feature-twenty-six', 'newsable'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));


	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'newsable_feature_change_style_control', array(
	    'label'    => __('Newsable - Change Style', 'newsable'),
	    'section'  => 'newsjolt_magazine_feature_section',
	    'settings' => 'newsable_feature_change_style_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-feature-eighteen' => __('Style 18 - ( IV Left side 2 Images 2 Right Images )', 'newsable'),
	    				'newsjolt-magazine-feature-twenty-six' 		=> __('Style 26 Newsable Layout', 'newsable'),
	    			   )
	)));




}


add_action('customize_register', 'newsable_layout_customizer_settings');	