<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News_Viral
 */ ?>
	<div class="story_contain">
		<div class="thumbnails">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php news_viral_post_thumbnail(); ?>
			</a>
		</div>
		<div class="thumbnails_detail">			
			<a href="<?php the_permalink(); ?>"><?php the_title( '<h2 class="entry-title">', '</h2>' ); ?></a>
			<div class="by">
				<span><i class="fa fa-user" aria-hidden="true"></i> <a href="#"><?php the_author();?></a></span>
				<span><i class="fa fa-calendar" aria-hidden="true"></i><?php echo esc_html(get_the_date()); ?></span>
			</div>
		</div>
		<div class="thumbnails_contain">
			<p><?php echo news_viral_excerpt(30); ?></p>
			<?php if(get_theme_mod('read_more_link',1) != 1): ?>  
                <a href="<?php the_permalink();?>" class="btn-light read_more_link"><?php esc_html_e('READ MORE','news-viral'); ?></a>
            <?php endif; ?> 
		</div>
	</div>