<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News_Viral
 */
?>
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		<?php news_viral_post_thumbnail(); ?>
		<?php if(!is_front_page()): ?>
	  	<header class="entry-header">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php //the_title( '<h1 class="entry-title">', '</h1>' ); ?></a>
		</header><!-- .entry-header -->
	<?php endif; ?>
		<div class="entry-content">
			<?php if ( 'post' === get_post_type() && get_theme_mod('blog_meta_tag') != 1) {
					news_viral_entry_meta();
				} 
				the_content();
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'news-viral' ),
					'after'  => '</div>',
				) );
			?>
			<?php if ( 'post' === get_post_type() && get_theme_mod('read_more_link') != 1):?>
			<a href="<?php the_permalink();?>" class="continue_read"><?php echo wp_kses_post(get_theme_mod('read_more_button_text')); ?></a>
			<?php endif; ?>
		</div><!-- .entry-content -->
		<?php if ( get_edit_post_link() ) : ?>
			<footer class="entry-footer">
				<?php
					edit_post_link(
						sprintf(
							wp_kses(
								/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Edit <span class="screen-reader-text">%s</span>', 'news-viral' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							get_the_title()
						),
						'<span class="edit-link">',
						'</span>'
					);
		?>
			</footer><!-- .entry-footer -->
		<?php endif; ?>
	</article><!-- #post-<?php the_ID(); ?> -->