<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News_Viral
 */
?>	
	<div class="story_contain">
		<div class="thumbnails">
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php news_viral_post_thumbnail(); ?>
			</a>
		</div>
		<div class="thumbnails_detail">			
			<a href="<?php the_permalink(); ?>"><?php the_title( '<h2 class="entry-title">', '</h2>' ); ?></a>
			
			<?php if ( 'post' === get_post_type() && get_theme_mod('blog_meta_tag') != 1) : ?>
			<div class="entry-meta">
				<?php news_viral_entry_meta(); ?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
		</div>
		<div class="thumbnails_contain">
			<p><?php echo news_viral_excerpt(30); ?></p>
			<?php if(get_theme_mod('read_more_link',1) != 1): ?>  
                <a href="<?php the_permalink();?>" class="btn-light read_more_link"><?php esc_html_e('READ MORE','news-viral'); ?></a>
            <?php endif; ?> 
		</div>
	</div>