<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package News_Viral
 */
get_header(); ?>
<div class="container padding-none">	
	<div class="row">
		<?php 
		$blog_layout_class=(get_theme_mod('single_sidebar_style','right_sidebar') == 'left_sidebar')?"8":((get_theme_mod('single_sidebar_style','right_sidebar') == 'right_sidebar')?"8":"12");
		 if(get_theme_mod('single_sidebar_style','right_sidebar')=='left_sidebar'){ ?>
		<!-- Left sidebar -->
		<div class="col-md-4 col-sm-4 col-xs-12">
			<div class="text-center">
	        	<?php get_sidebar(); ?>		
	        </div>
		</div> <!-- and Left sidebar -->
		<?php } ?>
		<div class="col-md-<?php echo esc_attr($blog_layout_class); ?> col-sm-<?php echo esc_attr($blog_layout_class); ?> col-xs-12">
			<?php
			while ( have_posts() ) : the_post(); ?>
			<div class="single-post-content">
				<?php
				get_template_part( 'template-parts/content', get_post_type() );
				the_post_navigation( array(
	            'prev_text'          => __( '<i class="fa fa-arrow-left" aria-hidden="true"></i>', 'news-viral' ),
	            'next_text'          => __( '<i class="fa fa-arrow-right" aria-hidden="true"></i>', 'news-viral' ),
	            'before_page_number' => __('<span class="meta-nav screen-reader-text"> Page </span>', 'news-viral' ),
	        	) );
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif; ?>
			</div>
			<?php endwhile; // End of the loop.?>
		</div>	
		<?php  if(get_theme_mod('single_sidebar_style','right_sidebar')=='right_sidebar'){ ?>
		<div class="col-md-4 col-sm-4 col-xs-12">
			<div class="right_sider text-center">
	        	<?php get_sidebar(); ?>		
	        </div>
		</div>
		<?php } ?>
    </div>
</div>
<?php
get_footer();