<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News_Viral
 */
get_header(); 	?>	
<div class="container padding-none">	
	<div class="row">
		<!-- content -->		
		<?php $sidebar_style = (!is_front_page() && is_page())?'single_sidebar_style':'blog_sidebar_style';		
		$blog_layout_class=(get_theme_mod($sidebar_style,'right_sidebar') == 'left_sidebar')?"8":((get_theme_mod($sidebar_style,'right_sidebar') == 'right_sidebar')?"8":"12");
		 if(get_theme_mod($sidebar_style,'right_sidebar')=='left_sidebar'){ ?>
		<!-- Left sidebar -->
		<div class="col-md-4 col-sm-4 col-xs-12">
			<div class="text-center">
	        	<?php get_sidebar(); ?>		
	        </div>
		</div> <!-- and Left sidebar -->
		<?php } ?>
		<div class="col-md-<?php echo esc_attr($blog_layout_class);?> col-sm-<?php echo esc_attr($blog_layout_class);?> col-xs-12">			
			  <?php
			 while ( have_posts() ) : the_post();
				get_template_part( 'template-parts/content', 'page' );
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
			endwhile; // End of the loop.
			if(!is_front_page()):
				the_post_navigation( array(
				    'prev_text' => __( '<i class="fa fa-arrow-left" aria-hidden="true"></i>', 'news-viral' ),
				    'next_text' => __( '<i class="fa fa-arrow-right" aria-hidden="true"></i>', 'news-viral' ),
				) ); 
			endif;
			?>
		</div><!-- and content -->
		<?php if(get_theme_mod($sidebar_style,'right_sidebar')=='right_sidebar'){ ?>
		<!-- right sidebar -->
		<div class="col-md-4 col-sm-4 col-xs-12">
			<div class="right_sidebar text-center">
	        	<?php get_sidebar(); ?>		
	        </div>
		</div>
		<?php } ?>
		<!-- and right sidebar -->
    </div>    
</div>
<?php
get_footer();