<?php 
function news_viral_slider_register_custom_widgets_template2() {
    register_widget( 'news_viral_slider_widget_recent_posts_template2' );
}
add_action( 'widgets_init', 'news_viral_slider_register_custom_widgets_template2' );
class news_viral_slider_widget_recent_posts_template2 extends WP_Widget {
    function __construct() {
        $widget_ops = array('classname' => 'news_viral_slider_widget_recent_posts_template2', 'description' => esc_html__( "The most recent posts on your slider", 'news-viral') );
        parent::__construct('recent-posts-template2', esc_html__('NV : Recent Post Side 3', 'news-viral'), $widget_ops);
        $this->alt_option_name = 'widget_recent_entries_template2';
        add_action( 'save_post', array($this, 'news_viral_slider_flush_widget_cache_temlate2') );
        add_action( 'deleted_post', array($this, 'news_viral_slider_flush_widget_cache_temlate2') );
        add_action( 'switch_theme', array($this, 'news_viral_slider_flush_widget_cache_temlate2') );
    }
    function widget($args, $instance) {
        wp_enqueue_style( 'viral-news-post-slider', get_template_directory_uri().'/inc/widgets/news-viral-latest-post-slider/style1.css',array(),null, false);
      
        $post_news_slider_cache = wp_cache_get('news_viral_slider_widget_recent_posts_template2', 'widget');
        if ( !is_array($post_news_slider_cache) )
            $post_news_slider_cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $post_news_slider_cache[ $args['widget_id'] ] ) ) {
            echo esc_attr($post_news_slider_cache[ $args['widget_id'] ]);
            return;
        }
        ob_start();
        extract($args);       
        
        $category_list = isset($instance['category']) ? $instance['category'] : '';        
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : ''; ?>
    <?php    $post_news_slider_r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => 3,'category__in' => $category_list, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
        if ($post_news_slider_r->have_posts()) :
        echo $args['before_widget'];     ?>
        <div class="row">
            <div class="elementor-widget-container">
                <div class="tg-row thinner">
                    <div class="tg-col-control">
                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                            <?php $count = 1;
                            while ( $post_news_slider_r->have_posts() ) : $post_news_slider_r->the_post();
                            $post_id = get_the_ID();
                            $category = get_the_category($post_id);
                            if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                            }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                            if($count < 3): ?>
                                <div class="tg_module_grid tg_module_grid--full tg_module_grid tg_module_grid--medium">
                                    <a class="tg-thumb-link" href="<?php the_permalink(); ?>">
                                        <img src='<?php echo esc_url($image); ?>' class="wp-post-image-style2">
                                    </a>
                                    <div class="tg-module-info">
                                        <div class="tg-post-categories">
                                            <?php foreach ($category as $key => $categories) { ?>
                                                <span class="cat-links">
                                                    <a class="tg-post-category" href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?>
                                                    </a>
                                                </span>
                                            <?php } ?>
                                        </div> 
                                        <h3 class="tg-module-title entry-title">
                                            <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                        </h3>
                                        <?php if( $show_date  ){ ?>
                                        <span class="posted-on">
                                            <a href="<?php the_permalink(); ?>" rel="bookmark">
                                                <i class="calendar fa fa-calendar-o"></i> 
                                                <span class="entry-date published"><?php echo esc_html(get_the_date('F d, Y')); ?></span>
                                            </a>
                                        </span>  
                                        <?php } ?>
                                        <span class="byline">
                                            <span class="author vcard">
                                                <i class="author fa fa-user"></i>
                                                <a class="url fn n" href='<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ))); ?>'><?php the_author(); ?></a>
                                            </span>
                                        </span>                                        
                                    </div>
                                </div>
                            <?php endif; $count++; endwhile; wp_reset_postdata(); ?>
                        </div>
                    </div>
                    <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12 tg-col-control news_viral_post_slider_style2">
                        <div id="news_post_slider" class="news_viral_post_slider2  bx-wrapper">
                            <?php  $count = 1; while ( $post_news_slider_r->have_posts() ) : $post_news_slider_r->the_post();
                                if($count > 2): 
                                    $post_id = get_the_ID();
                                    $category = get_the_category($post_id);
                                    
                                    if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                                     }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                                    ?>
                                    <div class="tg_module_grid tg_module_grid--full">
                                        <a href="<?php the_permalink(); ?>" class="tg-thumb-link">
                                            <img src='<?php echo esc_url($image); ?>' class="wp-post-slider-image-template2">
                                        </a>
                                        <div class="tg-module-info">
                                            <div class="tg-post-categories">
                                                <?php foreach ($category as $key => $categories) { ?>
                                                    <a class="tg-post-category" href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?>
                                                    </a>
                                                <?php } ?>
                                            </div>                     
                                            <h3 class="tg-module-title entry-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                            </h3>
                                            <?php if( $show_date  ){ ?>
                                            <span class="posted-on">
                                                <a href="<?php the_permalink(); ?>" rel="bookmark">
                                                    <i class="calendar fa fa-calendar-o"></i> 
                                                    <span class="entry-date published"><?php echo esc_html(get_the_date('F d, Y')); ?></span>
                                                </a>
                                            </span>  
                                            <?php } ?>
                                            <span class="byline">
                                                <span class="author vcard">
                                                    <i class="author fa fa-user"></i>
                                                    <a class="url fn n" href='<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ))); ?>'><?php the_author(); ?></a>
                                                </span>
                                            </span>                                            
                                        </div>
                                    </div>
                            <?php endif; $count++; endwhile;  wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $args['after_widget'];
        endif; ?>
      <?php  $post_news_slider_cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('news_viral_slider_widget_recent_posts_template2', $post_news_slider_cache, 'widget');
    }
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;    
        $instance['category'] = ( !empty( $new_instance['title']) && $new_instance['category'] > 0 ) ? absint($new_instance['category']):'';        
        $instance['number'] = ! empty( $new_instance['number'] ) ? absint( $new_instance['number'] ) : 3;  
        $instance['show_date'] = ! empty( $new_instance['show_date'] ) ? absint( $new_instance['show_date'] ) : '';

        $this->news_viral_slider_flush_widget_cache_temlate2();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['news_viral_slider_widget_recent_posts_template2']) )
            delete_option('news_viral_slider_widget_recent_posts_template2');
        return $instance;
    }
    function news_viral_slider_flush_widget_cache_temlate2() {
        wp_cache_delete('news_viral_slider_widget_recent_posts_template2', 'widget');
    }
    function form( $instance ) {
        $category_list  = isset($instance['category']) ? esc_attr($instance['category']) : '';       
        $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 10;
        $show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : ''; ?>
        
        <p><label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e( 'Latest 3 Number of posts to show ', 'news-viral' ); ?></label></p>
        
         <p>
            <label for=<?php echo esc_attr($this->get_field_id('category'));?>><?php esc_html_e('Select Post Category','news-viral'); ?></label>
            <?php wp_dropdown_categories(array('show_option_none'=>' Select', 'name'=> $this->get_field_name('category'),'selected'=> $category_list)); ?>
        </p>
        <p><input class="checkbox" type="checkbox" <?php checked( esc_attr($show_date) ); ?> id="<?php echo esc_attr($this->get_field_id('show_date')); ?>" value='1' name="<?php echo esc_attr($this->get_field_name('show_date')); ?>" />
        <label for="<?php echo esc_attr($this->get_field_id('show_date')); ?>"><?php esc_html_e( 'Display post date?', 'news-viral' ); ?></label></p>
<?php }
}