<?php 
function news_viral_top_footer_register_custom_widgets() {
    register_widget( 'news_viral_top_footer_widget_recent_posts' );
}
add_action( 'widgets_init', 'news_viral_top_footer_register_custom_widgets' );
class news_viral_top_footer_widget_recent_posts extends WP_Widget {
    function __construct() {
        $widget_ops = array('classname' => 'news_viral_top_footer_widget_recent_posts', 'description' => esc_html__( "The most recent posts on your site", 'news-viral') );
        parent::__construct('top-footer-category-posts', esc_html__('NV : Top Footer Recent Post', 'news-viral'), $widget_ops);
        $this->alt_option_name = 'news-viral-top-footer';
        add_action( 'save_post', array($this, 'news_viral_top_footer_flush_widget_cache') );
        add_action( 'deleted_post', array($this, 'news_viral_top_footer_flush_widget_cache') );
        add_action( 'switch_theme', array($this, 'news_viral_top_footer_flush_widget_cache') );
    }
    function widget($args, $instance) {
        wp_enqueue_style( 'news-viral-top-footer', get_template_directory_uri().'/inc/widgets/news-viral-footer-post-widgets/style1.css',array(),null, false);

        $news_viral_top_footer_cache = wp_cache_get('news_viral_top_footer_widget_recent_posts', 'widget');
        if ( !is_array($news_viral_top_footer_cache) )
            $news_viral_top_footer_cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $news_viral_top_footer_cache[ $args['widget_id'] ] ) ) {
            echo esc_attr($news_viral_top_footer_cache[ $args['widget_id'] ]);
            return;
        }
        ob_start();
        extract($args);
        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Recent Posts', 'news-viral' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
        $category_list = isset($instance['category']) ? $instance['category'] : '';
        if ( ! $number )
            $number = 5;
        $news_viral_top_footer_r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => $number,'category__in' => $category_list, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
        if ($news_viral_top_footer_r->have_posts()) :
        echo $args['before_widget']; 
        if ( $title ) echo $args['before_title'] . esc_html($title) . $args['after_title']; ?>
        <div class="tg-one-half">
            <div class="top-footer-post">
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <div class="top-footer-first-post">
                        <?php 
                        $count=1;
                        while ( $news_viral_top_footer_r->have_posts() ) : $news_viral_top_footer_r->the_post(); 
                         $post_id = get_the_ID();
                         $category = get_the_category($post_id);
                          
                         if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                        }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                         if($count < 4 && $count != 1): ?>
                                      
                                    <div class="top-footer-single-post clearfix">
                                        <a href="<?php the_permalink(); ?>" class="top-footer-thumb-link">
                                            <img src='<?php echo esc_url($image); ?>' class="top-footer-single-post-img">
                                        </a>
                                        <div class="footer-post-content">
                                            <div class="post-category-list">
                                                <span class="category-links">
                                                    <?php foreach ($category as $key => $categories) { ?>
                                                        <a href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?></a>
                                                    <?php } ?>
                                                </sapn>
                                            </div>         
                                            <h3 class="top-footer entry-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                            </h3>
                                        </div>
                                    </div>
                            
                        <?php endif; $count++; endwhile; wp_reset_postdata(); ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="top-footer-sec-post">
                        <?php
                        $news_viral_top_footer_r->the_post();
                        $post_id = get_the_ID();
                        $category = get_the_category($post_id);
                        if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                        }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                         ?>
                        <div class="top-footer-sec-one-post-col">            
                            <div class="top-footer-sec-one-post clearfix">
                                <a href="<?php the_permalink(); ?>" class="top-footer-thumb-link">
                                    <img src='<?php echo esc_url($image); ?>' class="top-footer-sec-img">
                                </a>   
                                <div class="footer-post-content">
                                    <div class="post-category-list">
                                        <span class="category-links">
                                            <?php foreach ($category as $key => $categories) { ?>
                                            <a href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?></a>
                                            <?php } ?>
                                            </sapn>
                                    </div>
                                    <h3 class="top-footer-sec entry-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                    </h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12">
                    <div class="top-footer-last-post-outer">
                        <?php
                        $count=1;
                        while ( $news_viral_top_footer_r->have_posts() ) : $news_viral_top_footer_r->the_post(); 
                         $post_id = get_the_ID();
                         $category = get_the_category($post_id);                        
                         if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                                     }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                            if($count > 2): ?>
                                       
                                    <div class="top-footer-last-post clearfix">
                                        <a href="<?php the_permalink(); ?>" class="top-footer-last-thumb-link">
                                            <img src='<?php echo esc_url($image); ?>' class="top-footer-last-post-img">
                                        </a> 
                                        <div class="footer-post-content">
                                            <div class="post-category-list">
                                                <span class="category-links">
                                                    <?php foreach ($category as $key => $categories) { ?>
                                                        <a href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?></a>
                                                    <?php } ?>
                                                </sapn>
                                            </div>           
                                            <h3 class="top-footer entry-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title();?></a>
                                            </h3>
                                        </div>
                                    </div>
                            
                        <?php endif; $count++; endwhile; wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $args['after_widget'];
        endif; ?>
      <?php  $news_viral_top_footer_cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('news_viral_top_footer_widget_recent_posts', $news_viral_top_footer_cache, 'widget');
    }
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;        
        $instance['category'] = ( !empty( $new_instance['title']) && $new_instance['category'] > 0 ) ? absint($new_instance['category']):'';
        $instance['title'] = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['number'] = ! empty( $new_instance['number'] ) ? absint( $new_instance['number'] ) : 3;        

        $this->news_viral_top_footer_flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['news_viral_top_footer_widget_recent_posts']) )
            delete_option('news_viral_top_footer_widget_recent_posts');
        return $instance;
    }
    function news_viral_top_footer_flush_widget_cache() {
        wp_cache_delete('news_viral_top_footer_widget_recent_posts', 'widget');
    }
    function form( $instance ) {
        $category_list  = isset($instance['category']) ? $instance['category'] : '';
        $title     = isset( $instance['title'] ) ?  $instance['title']  : '';
        $number    = isset( $instance['number'] ) ?  $instance['number'] : 5;       ?>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','news-viral' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of posts to show:', 'news-viral' ); ?></label>
        <input id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" value="<?php echo esc_attr($number); ?>" size="3" /></p>
         <p>
            <label for=<?php echo esc_attr($this->get_field_id('category'));?>><?php esc_html_e('Select Post Category','news-viral'); ?></label>
            <?php wp_dropdown_categories(array('show_option_none'=>' Select', 'name'=> $this->get_field_name('category'),'selected'=> $category_list)); ?>
        </p>        
<?php }
}