<?php 
function news_viral_category_register_custom_widgets_template2() {
    register_widget( 'news_viral_category_widget_recent_posts_template2' );
}
add_action( 'widgets_init', 'news_viral_category_register_custom_widgets_template2' );
class news_viral_category_widget_recent_posts_template2 extends WP_Widget {
    function __construct() {
        $widget_ops = array('classname' => 'news_viral_category_widget_recent_posts_template2', 'description' => esc_html__( "The most recent posts on your site", 'news-viral') );
        parent::__construct('category-posts-template1', esc_html__('NV : Recent Category Post(Style 2)', 'news-viral'), $widget_ops);
        $this->alt_option_name = 'widget_recent_post_template1';
        add_action( 'save_post', array($this, 'news_viral_category_flush_widget_cache_temlate3') );
        add_action( 'deleted_post', array($this, 'news_viral_category_flush_widget_cache_temlate3') );
        add_action( 'switch_theme', array($this, 'news_viral_category_flush_widget_cache_temlate3') );
    }
    function widget($args, $instance) {
        wp_enqueue_style( 'news-viral-template2', get_template_directory_uri().'/inc/widgets/news-viral-category-widgets-style2/style2.css',array(),null, false);

        $news_viral_category_cache = wp_cache_get('news_viral_category_widget_recent_posts_template2', 'widget');
        if ( !is_array($news_viral_category_cache) )
            $news_viral_category_cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $news_viral_category_cache[ $args['widget_id'] ] ) ) {
            echo esc_attr($news_viral_category_cache[ $args['widget_id'] ]);
            return;
        }
        ob_start();
        extract($args);
        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : esc_html__( 'Recent Posts', 'news-viral' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;
        $category_list = isset($instance['category']) ? $instance['category'] : '';
        if ( ! $number )
            $number = 3;
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : ''; ?>
    <?php    $news_viral_category_r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => $number,'category__in' => $category_list, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
        if ($news_viral_category_r->have_posts()) :
        echo $args['before_widget']; 
        if ( $title ) echo $args['before_title'] . esc_html($title) . $args['after_title']; ?>
        <div class="tg-one-half">
            <div class="row">
                <?php
                $news_viral_category_r->the_post(); 
                $post_id = get_the_ID();
                $category = get_the_category($post_id);
                if (has_post_thumbnail()){
                        $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                        $image = $image_array[0];
                }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                 ?>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="first-post">            
                        <div class="single-article-style3 clearfix">
                            <a href="<?php the_permalink(); ?>" class="tg-thumb-link">
                                <img src='<?php echo esc_url($image); ?>' class="attachment-featured-post-medium size-featured-post-medium wp-post-image" >
                            </a>
                            <div class="article-content">
                                <div class="above-entry-meta">
                                    <span class="cat-links">
                                        <?php foreach ($category as $key => $categories) { ?>
                                            <a href="<?php echo esc_url(get_category_link( $categories->term_id)); ?>" rel="category tag"><?php echo esc_html($categories->cat_name); ?></a>
                                        <?php } ?>
                                    </sapn>
                                </div>
								<a href="<?php the_permalink(); ?>">
									<h3 class="entry-title">
										<?php the_title();?>
									</h3>
								</a>
                                <div class="below-entry-meta">
                                    <?php if( $show_date  ){ ?>
                                    <span class="posted-on">
                                        <a href="<?php the_permalink(); ?>" rel="bookmark">
                                            <i class="fa fa-calendar-o"></i> 
                                            <time class="entry-date published"><?php echo esc_html(get_the_date('F d, Y')); ?></time>
                                        </a>
                                    </span>
                                    <?php }  ?>  
                                    <span class="byline">
                                        <span class="author vcard">
                                            <i class="fa fa-user"></i>
                                            <a href='<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ))); ?>'><?php the_author(); ?></a>
                                        </span>
                                    </span>  
                                </div>
                                <div class="entry-content">
                                    <p><?php the_excerpt(); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="following-post"> 
                        <?php 
                        while ( $news_viral_category_r->have_posts() ) : $news_viral_category_r->the_post();
                            $post_id = get_the_ID();
                            
                            if (has_post_thumbnail()){
                                    $image_array = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'large');
                                    $image = $image_array[0];
                            }else{  $image = get_template_directory_uri() .'/assets/images/no-image.png';  }
                             ?>
                            <div class="row single-article-style3 clearfix">
                                <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                    <a class="tg-thumb-link" href="<?php the_permalink(); ?>">
                                        <img src='<?php echo esc_url($image); ?>' class="attachment-featured-post-small size-featured-post-small wp-post-image">
                                    </a>
                                </div>
                                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">                  
                                    <a href="<?php the_permalink(); ?>">
										<h4 class="entry-title">
											<?php the_title();?>
										</h4>
									</a>
                                    <div class="below-entry-meta">
                                        <?php if( $show_date  ){ ?>
                                        <span class="posted-on">
                                            <a href="<?php the_permalink(); ?>" rel="bookmark">
                                                <i class="fa fa-calendar-o"></i> 
                                                <time class="entry-date published"><?php echo esc_html(get_the_date('F d, Y')); ?></time>
                                            </a>
                                        </span>
                                        <?php } ?>   
                                        <span class="byline">
                                            <span class="author vcard">
                                                <i class="fa fa-user"></i>
                                                <a href='<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ))); ?>'><?php the_author(); ?></a>
                                            </span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                          <?php endwhile; wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $args['after_widget'];
        endif; ?>
      <?php  $news_viral_category_cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('news_viral_category_widget_recent_posts_template2', $news_viral_category_cache, 'widget');
    }
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;       
        $instance['category'] = ( !empty( $new_instance['title']) && $new_instance['category'] > 0 ) ? absint($new_instance['category']):'';
        $instance['title'] = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['number'] = ! empty( $new_instance['number'] ) ? absint( $new_instance['number'] ) : 3;  
        $instance['show_date'] = ! empty( $new_instance['show_date'] ) ? absint( $new_instance['show_date'] ) : '';

        $this->news_viral_category_flush_widget_cache_temlate3();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['news_viral_category_widget_recent_posts_template2']) )
            delete_option('news_viral_category_widget_recent_posts_template2');
        return $instance;
    }
    function news_viral_category_flush_widget_cache_temlate3() {
        wp_cache_delete('news_viral_category_widget_recent_posts_template2', 'widget');
    }
    function form( $instance ) {
        $category_list  = isset($instance['category']) ? $instance['category'] : '';
        $title     = isset( $instance['title'] ) ?  $instance['title'] : '';
        $number    = isset( $instance['number'] ) ?  $instance['number'] : 3;
        $show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : ''; ?>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:','news-viral' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of posts to show:', 'news-viral' ); ?></label>
        <input id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" value="<?php echo esc_attr($number); ?>" size="3" /></p>
         <p>
            <label for=<?php echo esc_attr($this->get_field_id('category'));?>><?php esc_html_e('Select Post Category','news-viral'); ?></label>
            <?php wp_dropdown_categories(array('show_option_none'=>' Select', 'name'=> $this->get_field_name('category'),'selected'=> $category_list)); ?>
        </p>
        <p><input class="checkbox" type="checkbox" <?php checked( esc_attr($show_date) ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>" value="1" name="<?php echo esc_attr($this->get_field_name( 'show_date' )); ?>" />
        <label for="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>"><?php esc_html_e( 'Display post date?', 'news-viral' ); ?></label></p>
<?php }
}