<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package News_Viral
 */

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function news_viral_widgets_init() {
  register_sidebar( array(
    'name'          => esc_html__( 'Sidebar', 'news-viral' ),
    'id'            => 'sidebar-1',
    'description'   => esc_html__( 'Add widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget secondary-widget-area %2$s">',
    'after_widget'  => '</section>',
    'before_title'  => '<h2 class="widget-title">',
    'after_title'   => '</h2>',
  ) );
  register_sidebar(array(
    'name' => esc_html__('Header Banner', 'news-viral'),
    'id' => 'header-add',
    'description' => esc_html__('Set Header Banner News Viral.', 'news-viral'),
    'before_widget' => '<section id="%1$s" class="widget header-advertise-widget %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2>',
    'after_title' => '</h2>',
  ));  
  register_sidebar(array(
    'name' => esc_html__('Home Page First Section', 'news-viral'),
    'id' => 'home-top-slider-post',
    'description'   => esc_html__( 'Add VN : Recent Post Side 3 Widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget top-slider-post %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2 class="top-slider-post-title">',
    'after_title' => '</h2>',
  ));
  register_sidebar(array(
    'name' => esc_html__('Home Page Second Section Left', 'news-viral'),
    'id' => 'category-recent-post-left',
    'description'   => esc_html__( 'Add VN : Recent Category Post(style 1) Widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget category-recent-post-left %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2 class="category-recent-post-left-title">',
    'after_title' => '</h2>',
  ));
  register_sidebar(array(
    'name' => esc_html__('Home Page Third Section Right', 'news-viral'),
    'id' => 'category-recent-post-right',
    'description'   => esc_html__( 'Add VN : Recent Category Post(style 1) Widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget category-recent-post-right %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2 class="category-recent-post-right-title">',
    'after_title' => '</h2>',
  ));
  register_sidebar(array(
    'name' => esc_html__('Home Page Fourth Section', 'news-viral'),
    'id' => 'category-recent-post-style2',
    'description'   => esc_html__( 'Add VN : Recent Category Post(style 2) Widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget category-recent-post-style2 %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2 class="category-recent-post-style2-title">',
    'after_title' => '</h2>',
  ));
  register_sidebar(array(
    'name' => esc_html__('Home Page Fifth Section', 'news-viral'),
    'id' => 'footer-top-recent-category-post',
    'description'   => esc_html__( 'Add VN : Top Footer Recent Post Widgets here.', 'news-viral' ),
    'before_widget' => '<section id="%1$s" class="widget footer-top-recent-category-post %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h2 class="footer-top-recent-category-post-title">',
    'after_title' => '</h2>',
  ));
  register_sidebar(array(
    'name' => esc_html__('Top Footer', 'news-viral'),
    'id' => 'top-footer',
    'description' => esc_html__('Set Footer News Viral.', 'news-viral'),
    'before_widget' => '<section id="%1$s" class="widget footer-widget %2$s">',
    'after_widget' => '</section>',
    'before_title' => '<h1>',
    'after_title' => '</h1>',
  ));
  
} 
add_action( 'widgets_init', 'news_viral_widgets_init' );

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function news_viral_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	return $classes;
}
add_filter( 'body_class', 'news_viral_body_classes' );
// Menu default 

function news_viral_default_menu() {
    $html = '<ul id="menu-main-menu" class="offside">';
        $html .= '<li class="menu-item menu-item-type-post_type menu-item-object-page">';
            $html .= '<a href="' . esc_url( home_url() ) . '" title="' . esc_attr__( 'Home', 'news-viral' ) . '">';
                $html .= __( 'Home', 'news-viral' );
            $html .= '</a>';
        $html .= '</li>';
    $html .= '</ul>';
    echo $html;
}
/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function news_viral_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'news_viral_pingback_header' );

if ( ! function_exists( 'news_viral_post_thumbnail' ) ) :
/**
 * Displays an optional post thumbnail.
 *
 * Wraps the post thumbnail in an anchor element on index views, or a div
 * element when on single views.
 */
function news_viral_post_thumbnail() {
  if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
    return;
  }
  if ( is_singular() ) :  ?>
  <div class="post-thumbnail">
    <?php the_post_thumbnail('full', array('alt' => the_title_attribute( array('echo' => false) ),'class'=>'img-responsive', ) ); ?>
  </div><!-- .post-thumbnail -->
  <?php else : ?>
  <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true">
    <?php  the_post_thumbnail( 'post-thumbnail', array( 'alt' => the_title_attribute( array('echo' => false,) ),'class'=>'img-responsive',) ); ?>
  </a>
  <?php endif; // End is_singular().
}
endif;

function news_viral_excerpt($limit) {
  $excerpt = explode(' ', get_the_excerpt(), $limit);
  if (count($excerpt)>=$limit) {
    array_pop($excerpt);
    $excerpt = implode(" ",$excerpt).'...';
  } else {
    $excerpt = implode(" ",$excerpt);
  } 
  $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
  return $excerpt;
}
/**
 * Set up post entry meta.    
 * Meta information for current post: categories, tags, permalink, author, and date.    
 * */
function news_viral_entry_meta() {	
   $tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'news-viral' ) ); ?>	
    <div class="by"><span><i class="fa fa-user" aria-hidden="true"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="tag"><?php echo esc_attr(ucfirst(get_the_author())); ?></a></span><span> <i class="fa fa-calendar" aria-hidden="true"></i><?php echo sprintf('<time datetime="%1$s">%2$s</time>', esc_attr(get_the_date('c')), esc_html(get_the_date(get_option( 'date_format' )))); ?></span></div>
<?php 
}


add_action( 'tgmpa_register', 'news_viral_required_plugins' ); 
function news_viral_required_plugins() {
    if(class_exists('TGM_Plugin_Activation')){
      $plugins = array(
        array(
           'name'      => __('Page Builder by SiteOrigin','news-viral'),
           'slug'      => 'siteorigin-panels',
           'required'  => false,
        ),
        array(
           'name'      => __('SiteOrigin Widgets Bundle','news-viral'),
           'slug'      => 'so-widgets-bundle',
           'required'  => false,
        ),
        array(
           'name'      => __('Contact Form 7','news-viral'),
           'slug'      => 'contact-form-7',
           'required'  => false,
        ),
      );
      $config = array(
        'default_path' => '',
        'menu'         => 'news-viral-install-plugins',
        'has_notices'  => true,
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
        'strings'      => array(
           'page_title'                      => __( 'Install Recommended Plugins', 'news-viral' ),
           'menu_title'                      => __( 'Install Plugins', 'news-viral' ),           
           'nag_type'                        => 'updated'
        )
      );
      tgmpa( $plugins, $config );
    }
}