<?php
/**
 * News Viral Theme Customizer
 *
 * @package News_Viral
 */
/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
if ( ! function_exists( 'news_viral_field_sanitize_checkbox' ) ) :
  function news_viral_field_sanitize_checkbox( $checked ) {
    return ( ( isset( $checked ) && true === $checked ) ? true : false );
}
endif;

if ( ! function_exists( 'news_viral_field_sanitize_input_choice' ) ) :
function news_viral_field_sanitize_input_choice( $input, $setting ) {

  // Ensure input is a slug.
  $input = sanitize_key( $input );

  // Get list of choices from the control associated with the setting.
  $choices = $setting->manager->get_control( $setting->id )->choices;

  // If the input is a valid key, return it; otherwise, return the default.
  return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}
endif;

function news_viral_customize_register( $wp_customize ) {

	$wp_customize->add_panel(
   'news_viral_general',
   array(
     'title' => esc_html__( 'General Settings', 'news-viral' ),
     'description' => esc_html__('General options','news-viral'),
     'priority' => 20, 
     )
   ); 

  $wp_customize->get_section('title_tagline')->panel = 'news_viral_general';

  $wp_customize->get_section('header_image')->panel = 'news_viral_general';
  $wp_customize->get_section('static_front_page')->panel = 'news_viral_general';
  $wp_customize->get_section('title_tagline')->title = __('Header Logo','news-viral');

  if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'blogname', array(
      'selector'        => '.site-title a',
      'render_callback' => 'news_viral_customize_partial_blogname',
    ) );
    $wp_customize->selective_refresh->add_partial( 'blogdescription', array(
      'selector'        => '.site-description',
      'render_callback' => 'news_viral_customize_partial_blogdescription',
    ) );
  }

//social icons
$wp_customize->add_section(
    'news_viral_social_links',
    array(
      'title' => __('Header Social icons', 'news-viral'),
      'priority' => 120,
      'description' => __( 'In first input box, you need to add FONT AWESOME shortcode which you can find <a target="_blank" href="https://fortawesome.github.io/Font-Awesome/icons/">here</a> and in second input box, you need to add your social media profile URL.<br /> Enter the URL of your social accounts. Leave it empty to hide the icon.' , 'news-viral'),
      'panel' => 'news_viral_general'
    )
  );

$news_viral_social_icon = array();
for($i=1;$i <= 5;$i++):  
    $news_viral_social_icon[] =  array( 'slug'=>sprintf('news_viral_social_icon%d',$i),   
      'default' => '',   
      'label' => esc_html__( 'Social icons ', 'news-viral' ). $i,   
      'priority' => sprintf('%d',$i) );  
  endfor;
foreach($news_viral_social_icon as $news_viral_social_icons){
    $wp_customize->add_setting(
        $news_viral_social_icons['slug'],
        array(
          'default' => '',
          'capability'     => 'edit_theme_options',
          'type' => 'theme_mod',
          'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        $news_viral_social_icons['slug'],
        array(
            'section' => 'news_viral_social_links',
            'label'      =>   $news_viral_social_icons['label'],
            'priority' => $news_viral_social_icons['priority']
        )
    );
}
$news_viral_social_icon_links = array();
for($i=1;$i <= 5;$i++):  
    $news_viral_social_icon_links[] =  array( 'slug'=>sprintf('news_viral_social_icon_links%d',$i),   
      'default' => '',   
      'label' => esc_html__( 'Social Link ', 'news-viral' ) . $i,   
      'priority' => sprintf('%d',$i) );  
endfor;

foreach($news_viral_social_icon_links as $news_viral_social_icons){
    $wp_customize->add_setting(
        $news_viral_social_icons['slug'],
        array(
            'default' => '',
            'capability'     => 'edit_theme_options',
            'type' => 'theme_mod',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        $news_viral_social_icons['slug'],
        array(
            'section' => 'news_viral_social_links',
            'priority' => $news_viral_social_icons['priority']
        )
    );
}

/* Site  logo*/
$wp_customize->add_setting(
  'display_fixed_header',
  array(
    'capability'     => 'edit_theme_options',
    'sanitize_callback' => 'news_viral_field_sanitize_checkbox',
    'priority' => 20, 
    )
  );
$wp_customize->add_control(
  'display_fixed_header',
  array(
    'section' => 'title_tagline',                
    'label'   => __('Display Fixed Header','news-viral'),
    'type'    => 'checkbox',
    )
  );
	$wp_customize->add_setting(
  'news_viral_dark_logo',
  array(
    'default' => '',
    'capability'     => 'edit_theme_options',
    'sanitize_callback' => 'absint',
    )
  );
$wp_customize->add_control( new WP_Customize_Cropped_Image_Control( $wp_customize, 'news_viral_dark_logo', array(
  'section'     => 'title_tagline',
  'label'       => __( 'Upload Dark Logo (300 x 70)' ,'news-viral'),
  'flex_width'  => true,
  'flex_height' => true,
  'width'       => 120,
  'height'      => 50,
  'priority'    => 10,
  'default-image' => '',
  ) ) );
$wp_customize->add_setting(
  'logo_height',
  array(
    'default' => '',
    'capability'     => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
  );
$wp_customize->add_control(
  'logo_height',
  array(
    'section' => 'title_tagline',
    'label'      => __('Enter Logo Size', 'news-viral'),
    'description' => __("Use if you want to increase or decrease logo size (optional) Don't include `px` in the string. e.g. 20 (default: 10px)",'news-viral'),
    'type'       => 'text',
    'priority'    => 21,
    )
  );

//Add Blog Settings
$wp_customize->add_section( 'blog_settings' , array(
  'title'       => __( 'Blog (Archive) Settings', 'news-viral' ),
  'description' => __( 'These settings work for default blog.','news-viral' ),
  'priority'    => 32,
  'capability'     => 'edit_theme_options',
  'panel' => 'news_viral_general'
  ) );
$wp_customize->add_setting(
  'blog_sidebar_style',
  array(
    'default' => 'right_sidebar',
    'capability'     => 'edit_theme_options',
    'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
    )
  );
$wp_customize->add_control(
  'blog_sidebar_style',
  array(
    'section' => 'blog_settings',
    'label'      => __('Blog Sidebar Style', 'news-viral'),
    'type'       => 'select',
    'choices' => array(
      'no_sidebar'  => __('No Sidebar','news-viral'),
      'right_sidebar'  => __('Right Sidebar','news-viral'),
      'left_sidebar'  => __('Left Sidebar','news-viral'),
      ),
    )
  );
//blog meta tag
 $wp_customize->add_setting(
  'blog_meta_tag',
  array(
  'default' => '0',
  'capability'     => 'edit_theme_options',
  'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
    )
  );
$wp_customize->add_control(
  'blog_meta_tag',
  array(
  'section' => 'blog_settings',
    'label'      => __('Blog Meta Tag', 'news-viral'),
    'type'       => 'select',
    'choices' => array(
      '0'  => __('Show','news-viral'),
      '1'  => __('Hide','news-viral'),
      )
    )
  );

//read more link hide and show
$wp_customize->add_setting(
'read_more_link',
array(
'default' => '0',
'capability'     => 'edit_theme_options',
'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
  )
);
$wp_customize->add_control(
  'read_more_link',
  array(
  'section' => 'blog_settings',
  'label'      => __('Read More Link ', 'news-viral'),
  'type'       => 'select',
    'choices' => array(
      '0'  => __('Show','news-viral'),
      '1'  => __('Hide','news-viral'),
      )
    )
  );
//read more text
$wp_customize->add_setting(
  'read_more_button_text',
  array(
  'default' => 'Continue Reading...',
  'capability'     => 'edit_theme_options',
  'sanitize_callback' => 'sanitize_text_field',
    )
  );
$wp_customize->add_control(
  'read_more_button_text',
  array(
  'section' => 'blog_settings',
  'label'      => __('Read More button Text', 'news-viral'),
  'description' => __("Use if you want to change read more text.",'news-viral'),
  'type'       => 'text',  
    )
  );
//Add single Blog Settings
$wp_customize->add_section( 'single_blog_settings' , array(
  'title'       => __( 'Single Blog Settings', 'news-viral' ),
  'priority'    => 32,
  'capability'     => 'edit_theme_options',
  'panel' => 'news_viral_general'
) );
$wp_customize->add_setting(
  'single_sidebar_style',
  array(
    'default' => 'single_right_sidebar',
    'capability'     => 'edit_theme_options',
    'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
    )
  );
$wp_customize->add_control(
  'single_sidebar_style',
  array(
    'section' => 'single_blog_settings',
    'label'      => __('Singal Blog Sidebar Style', 'news-viral'),
    'type'       => 'select',
    'choices' => array(
      'no_sidebar'  => __('No Sidebar','news-viral'),
      'right_sidebar'  => __('Right Sidebar','news-viral'),
      'left_sidebar'  => __('Left Sidebar','news-viral'),
      ),
    )
  );
//singal blog meta tag
$wp_customize->add_setting(
  'singal_blog_meta_tag',
  array(
  'default' => '0',
  'capability'     => 'edit_theme_options',
  'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
    )
  );
$wp_customize->add_control(
'singal_blog_meta_tag',
array(
'section' => 'single_blog_settings',
  'label'      => __('Singal Blog Meta Tag', 'news-viral'),
  'type'       => 'select',
  'choices' => array(
    '0'  => __('Show','news-viral'),
    '1'  => __('Hide','news-viral'),
    )
  )
);
//category hide and show 
$wp_customize->add_setting(
'category_link',
array(
'default' => '0',
'capability'     => 'edit_theme_options',
'sanitize_callback' => 'news_viral_field_sanitize_input_choice',
  )
);
$wp_customize->add_control(
  'category_link',
  array(
  'section' => 'single_blog_settings',
  'label'      => __('Single Blog Category List ', 'news-viral'),
  'type'       => 'select',
    'choices' => array(
      '0'  => __('Show','news-viral'),
      '1'  => __('Hide','news-viral'),
      )
    )
  );
//Footer Section
$wp_customize->add_panel(
    'footer',
    array(
        'title' => __( 'Footer', 'news-viral' ),
        'description' => __('Footer options','news-viral'),
        'priority' => 150, 
    )
);
$wp_customize->add_section( 'footer_copyright_area' , array(
    'title'       => __( 'Footer Copyright Area', 'news-viral' ),
    'priority'    => 135,
    'capability'     => 'edit_theme_options',
    'panel' => 'footer'
) );
$wp_customize->add_setting(
    'Copyright_area_text',
    array(
        'capability'     => 'edit_theme_options',
        'sanitize_callback' => 'wp_kses_post',
        'priority' => 20, 
    )
);
$wp_customize->add_control(
    'Copyright_area_text',
    array(
        'section' => 'footer_copyright_area',                
        'label'   => __('Enter Copyright Text','news-viral'),
        'type'    => 'textarea',
    )
);
}
add_action( 'customize_register', 'news_viral_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function news_viral_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function news_viral_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

function news_viral_customs_css()
{
  wp_enqueue_style('news-viral-style', get_stylesheet_uri(), array()); 
  
  $custom_css = 'header li a i {
    color:#000;
  }
  h2.entry-title {
      margin: 0 0 10px;
  }
  h2.entry-title a {
    color: #000;
  }
  a:hover, a:focus {
    color: #000;
    text-decoration: underline;
  }';

  $logo_height = (get_theme_mod('logo_height'))?(get_theme_mod('logo_height')):55;
  $custom_css .=".header-logo .logo-fixed img, .header-logo .custom-logo-link .logo-dark {
         max-height: ".esc_attr($logo_height)."px;
      }";

  wp_add_inline_style( 'news-viral-style', $custom_css ); 

  $custom_js='';

  $display_fixed_header = get_theme_mod('display_fixed_header',true);
  if($display_fixed_header)
  {
    $custom_js = "jQuery(window).scroll(function () {
        if (jQuery(window).scrollTop() > 150) {
            jQuery('.news_viral_navigation').addClass('fixed-header');
        } else {
            jQuery('.news_viral_navigation').removeClass('fixed-header');           
            
        }
    });";  
  }

  wp_add_inline_script( 'news-viral-menu', $custom_js ); 
}