<?php
/**
*   The Header template for our theme
*/
?>
<!doctype html>
<html <?php language_attributes(); ?> >
<head>        
    <meta http-equiv="X-UA-Compatible" content="IE=edge">    
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <meta charset="<?php bloginfo( 'charset' ); ?>" >
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php endif;
    wp_head();  ?>
</head>
	<body <?php body_class();?> >
		<?php if ( function_exists( 'wp_body_open' ) ) { wp_body_open();   }  ?>
		<header class="header">
			<!-- top bar -->
			<div class="top_bar">
					<div class="container">
						<div class="row">
							<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
								<?php if(has_nav_menu('header-top-menu')): ?>
								<div class="top_bar_left">
									<?php
										$top_header_defaults = array(
	                                        'theme_location' => 'header-top-menu',
	                                        'container'       => false,
	                                        'menu_id' => 'header-top-menu',
	                                    );
	                                    wp_nav_menu($top_header_defaults);
	                                ?>
								</div>
							<?php endif; ?>
							</div>
							<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
								<!-- top right bar -->
								<div class="top_bar_right">
									<ul class="list-inline contain">
		                                <?php for($i=1; $i<=5; $i++) : ?>
	                                        <?php if(get_theme_mod('news_viral_social_icon'.$i) != '' && get_theme_mod('news_viral_social_icon_links'.$i) != '' ): ?>
	                                            <li>
	                                                <a href="<?php echo esc_url(get_theme_mod('news_viral_social_icon_links'.$i)); ?>" target="_blank">
	                                                    <i class="fa <?php echo esc_attr(get_theme_mod('news_viral_social_icon'.$i)); ?>"></i>
	                                                </a>
	                                            </li>
	                                        <?php endif; ?>
	                                    <?php endfor; ?>
		                            </ul>
								</div>
								<!-- end top right bar -->
							</div>
						</div>
					</div>
			</div>
			<!-- end top bar -->
			<!-- logo -->
			<div class="main_logo container">
				<div class="row">
					<div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
						<div class="logo_img header-logo logo">
							<?php $logo = '';
			                 if(has_custom_logo()){
			                        the_custom_logo();
			                    } 			                    
				                $scroll_logo=wp_get_attachment_url(esc_html(get_theme_mod('scroll_logo','')));
				                if($scroll_logo != ''){ ?>
				                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-logo-link" rel="home" itemprop="url">
				                        <img class="img-responsive logo-dark" src="<?php echo esc_url($scroll_logo); ?>" alt="<?php esc_attr_e('Logo','news-viral'); ?>">
				                    </a>
				                <?php } 				                
				                if(get_theme_mod('header_text',true)){
				                	printf('<div class="logo-light "><a href="%s" rel="home" class="site-title"><h4 class="custom-logo ">%s</h4></a><h6 class="custom-logo site-description">%s</h6></div>',esc_url( home_url('/')),esc_html(get_bloginfo('name')),esc_html(get_bloginfo('description')) );					            	
					             }?>
						</div>
					</div>
					
			    	<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
						<div class="header-right-content">
							<?php dynamic_sidebar('header-add'); ?>
						</div>
					</div>
				</div>
			</div>
			<!-- end logo -->
			<!-- menu -->
			<div class="news_viral_navigation">
					<div class="container">
						<div class="header_menu">
							<div class="row">							
								<div class="navbar navbar-static-top">
									<!-- navigation -->
									<div id='menucss' class="navigation">										
		                                <nav id='cssmenu'>
			                                <div id="box-top-mobile"></div>
			                                <div class="button"></div> 
			                                <?php
			                                if(has_nav_menu('header-menu')):
											$menu_defaults = array(
		                                        'theme_location' => 'header-menu',
		                                        'container'       => false,
		                                        'menu_id' => 'menu-main-menu',
		                                        'menu_class' => 'offside',
		                                    );
		                                    wp_nav_menu($menu_defaults);
		                                    else:
		                                    wp_nav_menu(
												array(
												  'theme_location' => 'header-menu',
												  'fallback_cb'    => 'news_viral_default_menu'
										    )); 
			                                endif;  ?>
			                             </nav>
									</div><!-- end navigation -->
								</div>
							</div>							
						</div>	
					</div>
			</div> <!-- menu -->
		</header>
		<!-- end header -->	
		<section id="main_contain">
			<div class="main_contain">
