<?php
/**
 * News Viral functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package News_Viral
 */
if ( ! function_exists( 'news_viral_setup' ) ) :
		function news_viral_setup() {		
		load_theme_textdomain( 'news-viral', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );		
		add_theme_support( 'title-tag' );		
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'header-top-menu' => esc_html__( 'Top Header', 'news-viral' ),
			'header-menu' => esc_html__( 'Header', 'news-viral' ),
			'footer-menu' => esc_html__( 'Footer', 'news-viral' ),
		) );

		add_theme_support( 'html5', array(			
			'comment-form',
			'comment-list',			
			'caption',
		) );

		
		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );

		$user = wp_get_current_user();
        update_user_option($user->ID, 'managenav-menuscolumnshidden',
            array( 0 => 'link-target',  1 => 'xfn', 2 => 'description', 3 => 'title-attribute', ),
            true);
	}
endif;
add_action( 'after_setup_theme', 'news_viral_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function news_viral_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'news_viral_content_width', 640 );
}
add_action( 'after_setup_theme', 'news_viral_content_width', 0 );


add_filter( 'nav_menu_css_class', 'news_viral_nav_menu_css_class' );
add_filter( 'walker_nav_menu_start_el', 'news_viral_walker_nav_menu_start_el', 10, 4 );

function news_viral_nav_menu_css_class( $classes ){
        if( is_array( $classes ) ){
            $tmp_classes = preg_grep( '/^(fa)(-\S+)?$/i', $classes );
            if( !empty( $tmp_classes ) ){
                $classes = array_values( array_diff( $classes, $tmp_classes ) );
            }
        }
        return $classes;
}
function news_viral_walker_nav_menu_start_el( $item_output, $item, $depth, $args ){
        if( is_array( $item->classes ) ){
            $classes = preg_grep( '/^(fa)(-\S+)?$/i', $item->classes );
            if( !empty( $classes ) ){
                $item_output = news_viral_replace_item( $item_output, $classes );
            }
        }
        return $item_output;
}
function news_viral_replace_item( $item_output, $classes ){       
       $spacer = ' ';
        if( !in_array( 'fa', $classes ) ){
            array_unshift( $classes, 'fa' );
        }

        $before = true;
        if( in_array( 'fa-after', $classes ) ){
            $classes = array_values( array_diff( $classes, array( 'fa-after' ) ) );
            $before = false;
        }

        $icon = '<i class="' . implode( ' ', $classes ) . '"></i>';

        preg_match( '/(<a.+>)(.+)(<\/a>)/i', $item_output, $matches );
        if( 4 === count( $matches ) ){
            $item_output = $matches[1];
            if( $before ){
                $item_output .= $icon . '<span class="fontawesome-text">' . $spacer . $matches[2] . '</span>';
            } else {
                $item_output .= '<span class="fontawesome-text">' . $matches[2] . $spacer . '</span>' . $icon;
            }
            $item_output .= $matches[3];
        }
        return $item_output;
    }

add_filter('get_custom_logo','news_viral_change_logo_class');
function news_viral_change_logo_class($html)
{
	$html = str_replace('class="custom-logo"', 'class="img-responsive logo-fixed"', $html);
	$html = str_replace('width=', 'original-width=', $html);
	$html = str_replace('height=', 'original-height=', $html);
	$html = str_replace('class="custom-logo-link"', 'class="img-responsive logo-fixed"', $html);
	return $html;
}
add_action( 'admin_menu', 'news_viral_admin_menu');
function news_viral_admin_menu( ) {
    add_theme_page( __('Pro Feature','news-viral'), __('News Viral Pro','news-viral'), 'manage_options', 'news-viral-pro-buynow', 'news_viral_pro_buy_now', 300 );   
}
function news_viral_pro_buy_now(){ ?>
<div class="news_viral_pro_version">
  <a href="<?php echo esc_url('https://piperthemes.com/wordpress-themes/news-viral-pro/'); ?>" target="_blank">
    <img src ="<?php echo esc_url('https://dlgf3dc8ohm1h.cloudfront.net/featured-images/news-viral-pro-features.png') ?>" width="100%" height="auto" />
  </a>
</div>
<?php
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/inc/enqueue.php';
require get_template_directory() . '/inc/template-setup.php';
require get_template_directory() . '/inc/customizer.php';

require get_template_directory() . '/inc/class-tgm-plugin-activation.php';

require get_template_directory() . '/inc/widgets/news-viral-category-widgets-style1/news-viral-category-widgets-style1.php';
require get_template_directory() . '/inc/widgets/news-viral-latest-post-slider/news-viral-latest-post-slider.php';

require get_template_directory() . '/inc/widgets/news-viral-category-widgets-style2/news-viral-category-widgets-style2.php';
require get_template_directory() . '/inc/widgets/news-viral-footer-post-widgets/news-viral-footer-post-widgets.php';