<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News_Viral
 */
get_header(); ?>
<div class="container padding-none">	
	<!-- Main -->
	<div class="row">
		<?php $blog_layout_class=(get_theme_mod('blog_sidebar_style','right_sidebar') == 'left_sidebar')?"8":((get_theme_mod('blog_sidebar_style','right_sidebar') == 'right_sidebar')?"8":"12");
		 if(get_theme_mod('blog_sidebar_style','right_sidebar')=='left_sidebar'){ ?>
		<!-- Left sidebar -->
		<div class="col-md-4 col-sm-4 col-xs-12">
			<div class="text-center">
	        	<?php get_sidebar(); ?>		
	        </div>
		</div> <!-- and Left sidebar -->
		<?php } ?>
		<!-- content -->
		<div class="col-md-8 col-sm-8 col-xs-12">	
			<div class="story_contain">
				<?php
				if ( have_posts() ) : ?>
					<header class="news_title">
						<?php
							the_archive_title( '<h3 class="post-page-title">', '</h3>' );							
						?>
					</header><!-- .page-header -->
					<div class="row">
						<?php
						/* Start the Loop */
						while ( have_posts() ) : the_post(); ?>
						<div class="col-md-6 col-sm-6 col-xs-12">
							<?php get_template_part( 'template-parts/content', 'blog' ); ?>
						</div>
						<?php endwhile; ?>
					</div>
					<?php the_posts_pagination( array(
					    'prev_text' => __( '<i class="fa fa-arrow-left" aria-hidden="true"></i>', 'news-viral' ),
					    'next_text' => __( '<i class="fa fa-arrow-right" aria-hidden="true"></i>', 'news-viral' ),
					) ); 
				else :
					get_template_part( 'template-parts/content', 'none' );
				endif; ?>
			</div>
		</div><!-- and content -->
		<?php if(get_theme_mod('blog_sidebar_style','right_sidebar')=='right_sidebar'){ ?>
        <!-- Right sidebar -->
		<div class="col-md-4 col-sm-4 col-xs-12">
	        <?php get_sidebar(); ?>		
		</div>
		<!-- and Right sidebar -->
		<?php } ?>
    </div><!-- and Main  -->
</div>
<?php 
get_footer();