<?php
$main_news_query = new WP_Query( $main_news_args );
if ( $main_news_query->have_posts() ) {
	$excerpt_length = get_theme_mod( 'news_vault_main_news_excerpt_length', 25 );
	?>
	<div class="banner-main-part">
		<div class="banner-main-wrap">
			<?php
			$i = 1;
			while ( $main_news_query->have_posts() ) :
				$main_news_query->the_post();
				$banner_style = get_theme_mod( 'news_vault_banner_section_style', 'banner-style-1' );
				if ( $banner_style === 'banner-style-1' ) {
					$class = ( $i === 1 ) ? 'grid-layout' : 'list-layout';
				} else {
					$class = ( $i === 1 ) ? 'list-layout' : 'grid-layout';
				}
				?>
				<div class="blog-post-container <?php echo esc_attr( $class ); ?>"> 
					<div class="blog-post-inner">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="blog-post-image">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'full' ); ?></a>
							</div>
						<?php } ?>
						<div class="blog-post-detail">
							<?php news_vault_categories_list(); ?>
							<h2 class="entry-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h2>
							<?php if ( $i === 1 ) { ?>
								<p class="post-excerpt">
									<?php echo wp_kses_post( wp_trim_words( get_the_content(), $excerpt_length ) ); ?>
								</p>
							<?php } ?>
							<div class="post-meta">
								<?php
								news_vault_posted_by();
								news_vault_posted_on();
								?>
							</div>
						</div>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
