<?php
$editor_query = new WP_Query( $editor_args );
if ( $editor_query->have_posts() ) {
	$editor_title = get_theme_mod( 'news_vault_editor_choice_title', __( 'Editor Choice', 'news-vault' ) );
	?>
	<div class="editors-choice">
		<?php if ( ! empty( $editor_title) ) { ?>
			<div class="title-heading">
				<h3 class="section-title"><?php echo esc_html( $editor_title ); ?></h3>
			</div>
		<?php } ?>
		<div class="editors-choice-wrap">
			<?php
			$i = 1;
			while ( $editor_query->have_posts() ) :
				$editor_query->the_post();
				$banner_style = get_theme_mod( 'news_vault_banner_section_style', 'banner-style-1' );
				$class        = ( $banner_style === 'banner-style-1' && ( $i === 2 || $i === 3 ) ) ? 'tile-layout' : 'grid-layout';
				?>
				<div class="blog-post-container <?php echo esc_attr( $class ); ?>">
					<div class="blog-post-inner">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="blog-post-image">
								<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'post-thumbnail' ); ?></a>
							</div>
						<?php } ?>
						<div class="blog-post-detail">
							<?php news_vault_categories_list(); ?>
							<h2 class="entry-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h2>
							<div class="post-meta">
								<?php
								news_vault_posted_by();
								news_vault_posted_on();
								?>
							</div>
						</div>
					</div>
				</div>
				<?php
				$i++;
			endwhile;
			wp_reset_postdata();
			?>
		</div>
	</div>
	<?php
}
