<?php
if ( ! get_theme_mod( 'news_vault_enable_banner_section', false ) ) {
	return;
}

$main_news_content_ids = $editor_content_ids = array();
$main_content_type     = get_theme_mod( 'news_vault_main_news_content_type', 'post' );
$editor_content_type   = get_theme_mod( 'news_vault_editor_choice_content_type', 'post' );

if ( $main_content_type === 'post' ) {
	for ( $i = 1; $i <= 2; $i++ ) {
		$main_news_content_ids[] = get_theme_mod( 'news_vault_main_news_content_post_' . $i );
	}
	$main_news_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 2 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $main_news_content_ids ) ) ) {
		$main_news_args['post__in'] = array_filter( $main_news_content_ids );
		$main_news_args['orderby']  = 'post__in';
	} else {
		$main_news_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'news_vault_main_news_content_category' );
	$main_news_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 2 ),
	);
}
$main_news_args = apply_filters( 'news_vault_banner_section_args', $main_news_args );

if ( $editor_content_type === 'post' ) {
	for ( $i = 1; $i <= 4; $i++ ) {
		$editor_content_ids[] = get_theme_mod( 'news_vault_editor_choice_content_post_' . $i );
	}
	$editor_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 4 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $editor_content_ids ) ) ) {
		$editor_args['post__in'] = array_filter( $editor_content_ids );
		$editor_args['orderby']  = 'post__in';
	} else {
		$editor_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'news_vault_editor_choice_content_category' );
	$editor_args    = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 4 ),
	);
}
$editor_args = apply_filters( 'news_vault_banner_section_args', $editor_args );

news_vault_render_banner_section( $main_news_args, $editor_args );

/**
 * Render Banner Section.
 */
function news_vault_render_banner_section( $main_news_args, $editor_args ) {
	?>

	<section id="news_vault_banner_section"  class="magazine-banner section-splitter banner-style-1">
		<?php
		if ( is_customize_preview() ) :
			news_vault_section_link( 'news_vault_banner_section' );
		endif;
		?>
		<div class="section-wrapper">
			<div class="banner-container-wrapper">

				<?php

				require get_template_directory() . '/template-parts/sections/banner/main-banner.php';

				require get_template_directory() . '/template-parts/sections/banner/editors-choice.php';

				?>

			</div>
		</div>
	</section>

	<?php

}
