<?php

function news_vault_intro_text( $default_text ) {
	$default_text .= sprintf(
		'<div class="notice notice-info news-vault-demo-data"><p class="demo-file-content">%1$s <a href="%2$s" target="_blank">%3$s</a></p></div>',
		esc_html__( 'Demo content files for News Vault Theme.', 'news-vault' ),
		esc_url( 'https://docs.ascendoor.com/docs/news-vault/getting-started/import-demo-content/' ),
		esc_html__( 'Click here to download demo files.', 'news-vault' )
	);
	return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'news_vault_intro_text' );

/**
 * OCDI after import.
 */
function news_vault_after_import_setup() {
	// Assign menus to their locations.
	$news_vault_primary_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
	$news_vault_social_menu  = get_term_by( 'name', 'Social Menu', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations',
		array(
			'primary' => $news_vault_primary_menu->term_id,
			'social'  => $news_vault_social_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$news_vault_front_page_id = get_page_by_title( 'Home' );
	$news_vault_blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $news_vault_front_page_id->ID );
	update_option( 'page_for_posts', $news_vault_blog_page_id->ID );

}
add_action( 'ocdi/after_import', 'news_vault_after_import_setup' );
