<?php

/**
 * Dynamic CSS
 */
function news_vault_dynamic_css() {

	$site_title_font       = get_theme_mod( 'news_vault_site_title_font', 'Raleway' );
	$site_description_font = get_theme_mod( 'news_vault_site_description_font', 'Poppins' );
	$header_font           = get_theme_mod( 'news_vault_header_font', 'Raleway' );
	$body_font             = get_theme_mod( 'news_vault_body_font', 'Poppins' );

	$custom_css  = '';
	$custom_css .= '
	/* Color */
	:root {
		--site-title-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
		--custom-bg-clr: ' . esc_attr( '#' . get_background_color() ) . ';
	}
	';

	$custom_css .= '
	/* Typograhpy */
	:root {
		--site-title-font: "' . esc_attr( $site_title_font ) . '", serif;
		--site-description-font: "' . esc_attr( $site_description_font ) . '", serif;
		--font-heading: "' . esc_attr( $header_font ) . '", serif;
		--font-body: "' . esc_attr( $body_font ) . '", serif;
	}
	';

	wp_add_inline_style( 'news-vault-style', $custom_css );

}

add_action( 'wp_enqueue_scripts', 'news_vault_dynamic_css', 99 );
