<?php
/**
 * Typography
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_typography',
	array(
		'panel' => 'news_vault_theme_options',
		'title' => esc_html__( 'Typography', 'news-vault' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'news_vault_site_title_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'news_vault_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'news_vault_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'news-vault' ),
		'section'  => 'news_vault_typography',
		'settings' => 'news_vault_site_title_font',
		'type'     => 'select',
		'choices'  => news_vault_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'news_vault_site_description_font',
	array(
		'default'           => 'Poppins',
		'sanitize_callback' => 'news_vault_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'news_vault_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'news-vault' ),
		'section'  => 'news_vault_typography',
		'settings' => 'news_vault_site_description_font',
		'type'     => 'select',
		'choices'  => news_vault_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'news_vault_header_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'news_vault_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'news_vault_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'news-vault' ),
		'section'  => 'news_vault_typography',
		'settings' => 'news_vault_header_font',
		'type'     => 'select',
		'choices'  => news_vault_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'news_vault_body_font',
	array(
		'default'           => 'Poppins',
		'sanitize_callback' => 'news_vault_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'news_vault_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'news-vault' ),
		'section'  => 'news_vault_typography',
		'settings' => 'news_vault_body_font',
		'type'     => 'select',
		'choices'  => news_vault_get_all_google_font_families(),
	)
);
