<?php
/**
 * Sidebar Option
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_sidebar_option',
	array(
		'title' => esc_html__( 'Layout', 'news-vault' ),
		'panel' => 'news_vault_theme_options',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'news_vault_sidebar_position',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'news_vault_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'news-vault' ),
		'section' => 'news_vault_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'news-vault' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'news-vault' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'news_vault_post_sidebar_position',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'news_vault_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'news-vault' ),
		'section' => 'news_vault_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'news-vault' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'news-vault' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'news_vault_page_sidebar_position',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'news_vault_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'news-vault' ),
		'section' => 'news_vault_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'news-vault' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'news-vault' ),
		),
	)
);
