<?php
/**
 * Post Options
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'news-vault' ),
		'panel' => 'news_vault_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'news_vault_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'news-vault' ),
			'section' => 'news_vault_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'news_vault_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'news-vault' ),
			'section' => 'news_vault_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'news_vault_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'news-vault' ),
			'section' => 'news_vault_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'news_vault_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'news-vault' ),
			'section' => 'news_vault_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'news_vault_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'news-vault' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'news_vault_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'news-vault' ),
		'section'  => 'news_vault_post_options',
		'settings' => 'news_vault_post_related_post_label',
		'type'     => 'text',
	)
);
