<?php
/**
 * Pagination
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_pagination',
	array(
		'panel' => 'news_vault_theme_options',
		'title' => esc_html__( 'Pagination', 'news-vault' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'news_vault_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'news-vault' ),
			'section'  => 'news_vault_pagination',
			'settings' => 'news_vault_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'news_vault_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'news-vault' ),
		'section'         => 'news_vault_pagination',
		'settings'        => 'news_vault_pagination_type',
		'active_callback' => 'news_vault_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default'  => __( 'Default (Older/Newer)', 'news-vault' ),
			'numeric'  => __( 'Numeric', 'news-vault' ),
		),
	)
);
