<?php
/**
 * Header Options
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_header_options',
	array(
		'panel' => 'news_vault_theme_options',
		'title' => esc_html__( 'Header Options', 'news-vault' ),
	)
);

// Header Options - Advertisement.
$wp_customize->add_setting(
	'news_vault_header_advertisement',
	array(
		'default'           => '',
		'sanitize_callback' => 'news_vault_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'news_vault_header_advertisement',
		array(
			'label'    => esc_html__( 'Advertisement', 'news-vault' ),
			'section'  => 'news_vault_header_options',
			'settings' => 'news_vault_header_advertisement',
		)
	)
);

	// Header Options - Advertisement URL.
$wp_customize->add_setting(
	'news_vault_header_advertisement_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'news_vault_header_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'news-vault' ),
		'section'  => 'news_vault_header_options',
		'settings' => 'news_vault_header_advertisement_url',
		'type'     => 'url',
	)
);
