<?php
/**
 * Footer Options
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_footer_options',
	array(
		'panel' => 'news_vault_theme_options',
		'title' => esc_html__( 'Footer Options', 'news-vault' ),
	)
);

// Footer Options - Copyright Text.
/* translators: 1: Year, 2: Site Title with home URL. */
$copyright_default = sprintf( esc_html_x( 'Copyright &copy; %1$s %2$s', '1: Year, 2: Site Title with home URL', 'news-vault' ), '[the-year]', '[site-link]' );
$wp_customize->add_setting(
	'news_vault_footer_copyright_text',
	array(
		'default'           => $copyright_default,
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'news_vault_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'news-vault' ),
		'section'  => 'news_vault_footer_options',
		'settings' => 'news_vault_footer_copyright_text',
		'type'     => 'textarea',
	)
);
