<?php
/**
 * Excerpt
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_excerpt_options',
	array(
		'panel' => 'news_vault_theme_options',
		'title' => esc_html__( 'Excerpt', 'news-vault' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'news_vault_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'news_vault_sanitize_number_range',
		'validate_callback' => 'news_vault_validate_excerpt_length',
	)
);

$wp_customize->add_control(
	'news_vault_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'news-vault' ),
		'description' => esc_html__( 'Note: Min 1 & Max 100. Please input the valid number and save. Then refresh the page to see the change.', 'news-vault' ),
		'section'     => 'news_vault_excerpt_options',
		'settings'    => 'news_vault_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 100,
			'step' => 1,
		),
	)
);
