<?php
/**
 * Breadcrumb
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'news-vault' ),
		'panel' => 'news_vault_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'news_vault_enable_breadcrumb',
	array(
		'sanitize_callback' => 'news_vault_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'news-vault' ),
			'section' => 'news_vault_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'news_vault_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'news_vault_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'news-vault' ),
		'active_callback' => 'news_vault_is_breadcrumb_enabled',
		'section'         => 'news_vault_breadcrumb',
	)
);
