<?php
/**
 * Archive Layout
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_archive_layout',
	array(
		'title' => esc_html__( 'Archive Layout', 'news-vault' ),
		'panel' => 'news_vault_theme_options',
	)
);

// Archive Layout - Column Layout.
$wp_customize->add_setting(
	'news_vault_archive_column_layout',
	array(
		'default'           => 'column-2',
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_archive_column_layout',
	array(
		'label'   => esc_html__( 'Column Layout', 'news-vault' ),
		'section' => 'news_vault_archive_layout',
		'type'    => 'select',
		'choices' => array(
			'column-2' => __( 'Column 2', 'news-vault' ),
			'column-3' => __( 'Column 3', 'news-vault' ),
		),
	)
);
