<?php
/**
 * Flash News Section
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_flash_news_section',
	array(
		'panel' => 'news_vault_front_page_options',
		'title' => esc_html__( 'Flash News Section', 'news-vault' ),
	)
);

// Flash News Section - Enable Section.
$wp_customize->add_setting(
	'news_vault_enable_flash_news_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_enable_flash_news_section',
		array(
			'label'    => esc_html__( 'Enable Flash News Section', 'news-vault' ),
			'section'  => 'news_vault_flash_news_section',
			'settings' => 'news_vault_enable_flash_news_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'news_vault_enable_flash_news_section',
		array(
			'selector' => '#news_vault_flash_news_section .section-link',
			'settings' => 'news_vault_enable_flash_news_section',
		)
	);
}

// Flash News Section - Section Title.
$wp_customize->add_setting(
	'news_vault_flash_news_title',
	array(
		'default'           => __( 'Flash News', 'news-vault' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'news_vault_flash_news_title',
	array(
		'label'           => esc_html__( 'Section Title', 'news-vault' ),
		'section'         => 'news_vault_flash_news_section',
		'settings'        => 'news_vault_flash_news_title',
		'type'            => 'text',
		'active_callback' => 'news_vault_is_flash_news_section_enabled',
	)
);

// Flash News Section - Speed Controller.
$wp_customize->add_setting(
	'news_vault_flash_news_speed_controller',
	array(
		'default'           => 30,
		'sanitize_callback' => 'news_vault_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'news_vault_flash_news_speed_controller',
	array(
		'label'           => esc_html__( 'Speed Controller', 'news-vault' ),
		'description'     => esc_html__( 'Note: Default speed value is 30.', 'news-vault' ),
		'section'         => 'news_vault_flash_news_section',
		'settings'        => 'news_vault_flash_news_speed_controller',
		'type'            => 'number',
		'input_attrs'     => array(
			'min' => 1,
		),
		'active_callback' => 'news_vault_is_flash_news_section_enabled',
	)
);

// Flash News Section - Content Type.
$wp_customize->add_setting(
	'news_vault_flash_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_flash_news_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'news-vault' ),
		'section'         => 'news_vault_flash_news_section',
		'settings'        => 'news_vault_flash_news_content_type',
		'type'            => 'select',
		'active_callback' => 'news_vault_is_flash_news_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'news-vault' ),
			'category' => esc_html__( 'Category', 'news-vault' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Flash News Section - Select Post.
	$wp_customize->add_setting(
		'news_vault_flash_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'news_vault_flash_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'news-vault' ), $i ),
			'section'         => 'news_vault_flash_news_section',
			'settings'        => 'news_vault_flash_news_content_post_' . $i,
			'active_callback' => 'news_vault_is_flash_news_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => news_vault_get_post_choices(),
		)
	);

}

// Flash News Section - Select Category.
$wp_customize->add_setting(
	'news_vault_flash_news_content_category',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_flash_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'news-vault' ),
		'section'         => 'news_vault_flash_news_section',
		'settings'        => 'news_vault_flash_news_content_category',
		'active_callback' => 'news_vault_is_flash_news_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => news_vault_get_post_cat_choices(),
	)
);
