<?php
/**
 * Banner Section
 *
 * @package News Vault
 */

$wp_customize->add_section(
	'news_vault_banner_section',
	array(
		'panel' => 'news_vault_front_page_options',
		'title' => esc_html__( 'Banner Section', 'news-vault' ),
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'news_vault_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'news_vault_sanitize_switch',
	)
);

$wp_customize->add_control(
	new News_Vault_Toggle_Switch_Custom_Control(
		$wp_customize,
		'news_vault_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'news-vault' ),
			'section'  => 'news_vault_banner_section',
			'settings' => 'news_vault_enable_banner_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'news_vault_enable_banner_section',
		array(
			'selector' => '#news_vault_banner_section .section-link',
			'settings' => 'news_vault_enable_banner_section',
		)
	);
}

// Banner Section - Slider Heading.
$wp_customize->add_setting(
	'news_vault_main_news_section_area',
	array(
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	new News_Vault_Title_Control(
		$wp_customize,
		'news_vault_main_news_section_area',
		array(
			'label'           => __( 'Main News Settings', 'news-vault' ),
			'section'         => 'news_vault_banner_section',
			'settings'        => 'news_vault_main_news_section_area',
			'active_callback' => 'news_vault_is_banner_section_enabled',
		)
	)
);

// Banner Section - Main News Content Type.
$wp_customize->add_setting(
	'news_vault_main_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_main_news_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'news-vault' ),
		'section'         => 'news_vault_banner_section',
		'settings'        => 'news_vault_main_news_content_type',
		'type'            => 'select',
		'active_callback' => 'news_vault_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'news-vault' ),
			'category' => esc_html__( 'Category', 'news-vault' ),
		),
	)
);

for ( $i = 1; $i <= 2; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'news_vault_main_news_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'news_vault_main_news_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'news-vault' ), $i ),
			'section'         => 'news_vault_banner_section',
			'settings'        => 'news_vault_main_news_content_post_' . $i,
			'active_callback' => 'news_vault_is_main_news_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => news_vault_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'news_vault_main_news_content_category',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_main_news_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'news-vault' ),
		'section'         => 'news_vault_banner_section',
		'settings'        => 'news_vault_main_news_content_category',
		'active_callback' => 'news_vault_is_main_news_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => news_vault_get_post_cat_choices(),
	)
);

// Banner Section - Editor Choice Heading.
$wp_customize->add_setting(
	'news_vault_editor_choice_area',
	array(
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	new News_Vault_Title_Control(
		$wp_customize,
		'news_vault_editor_choice_area',
		array(
			'label'           => __( 'Editor Choice Settings', 'news-vault' ),
			'section'         => 'news_vault_banner_section',
			'settings'        => 'news_vault_editor_choice_area',
			'active_callback' => 'news_vault_is_banner_section_enabled',
		)
	)
);

// Banner Section - Editor Choice Title.
$wp_customize->add_setting(
	'news_vault_editor_choice_title',
	array(
		'default'           => __( 'Editor Choice', 'news-vault' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'news_vault_editor_choice_title',
	array(
		'label'           => esc_html__( 'Section Title', 'news-vault' ),
		'section'         => 'news_vault_banner_section',
		'settings'        => 'news_vault_editor_choice_title',
		'type'            => 'text',
		'active_callback' => 'news_vault_is_banner_section_enabled',
	)
);

// Banner Section - Editor Choice Content Type.
$wp_customize->add_setting(
	'news_vault_editor_choice_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_editor_choice_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'news-vault' ),
		'section'         => 'news_vault_banner_section',
		'settings'        => 'news_vault_editor_choice_content_type',
		'type'            => 'select',
		'active_callback' => 'news_vault_is_banner_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'news-vault' ),
			'category' => esc_html__( 'Category', 'news-vault' ),
		),
	)
);

for ( $i = 1; $i <= 4; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'news_vault_editor_choice_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'news_vault_editor_choice_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'news-vault' ), $i ),
			'section'         => 'news_vault_banner_section',
			'settings'        => 'news_vault_editor_choice_content_post_' . $i,
			'active_callback' => 'news_vault_is_editor_choice_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => news_vault_get_post_choices(),
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'news_vault_editor_choice_content_category',
	array(
		'sanitize_callback' => 'news_vault_sanitize_select',
	)
);

$wp_customize->add_control(
	'news_vault_editor_choice_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'news-vault' ),
		'section'         => 'news_vault_banner_section',
		'settings'        => 'news_vault_editor_choice_content_category',
		'active_callback' => 'news_vault_is_editor_choice_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => news_vault_get_post_cat_choices(),
	)
);
