<?php

/**
 * Active Callbacks
 *
 * @package News Vault
 */

// Theme Options.
function news_vault_is_pagination_enabled( $control ) {
	return ( $control->manager->get_setting( 'news_vault_enable_pagination' )->value() );
}
function news_vault_is_breadcrumb_enabled( $control ) {
	return ( $control->manager->get_setting( 'news_vault_enable_breadcrumb' )->value() );
}

// Flash News Section.
function news_vault_is_flash_news_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'news_vault_enable_flash_news_section' )->value() );
}
function news_vault_is_flash_news_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_flash_news_content_type' )->value();
	return ( news_vault_is_flash_news_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function news_vault_is_flash_news_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_flash_news_content_type' )->value();
	return ( news_vault_is_flash_news_section_enabled( $control ) && ( 'category' === $content_type ) );
}

// Banner Section.
function news_vault_is_banner_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'news_vault_enable_banner_section' )->value() );
}

// Banner Section - Main Banner.
function news_vault_is_main_news_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_main_news_content_type' )->value();
	return ( news_vault_is_banner_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function news_vault_is_main_news_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_main_news_content_type' )->value();
	return ( news_vault_is_banner_section_enabled( $control ) && ( 'category' === $content_type ) );
}
// Banner Section - Editor Choice.
function news_vault_is_editor_choice_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_editor_choice_content_type' )->value();
	return ( news_vault_is_banner_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function news_vault_is_editor_choice_section_and_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'news_vault_editor_choice_content_type' )->value();
	return ( news_vault_is_banner_section_enabled( $control ) && ( 'category' === $content_type ) );
}

// Check if static home page is enabled.
function news_vault_is_static_homepage_enabled( $control ) {
	return ( 'page' === $control->manager->get_setting( 'show_on_front' )->value() );
}
