<?php

/**
 * Option Panel
 *
 * @package Newsmaz
 */

function newsmaz_customize_register($wp_customize) {

$newsup_default = newsmaz_get_default_theme_options();

$wp_customize->add_section('newsmaz_top_recent_post_settings',
    array(
        'title' => esc_html__('Top Recent Post', 'news-maz'),
        'priority' => 50,
        'capability' => 'edit_theme_options',
        'panel' => 'frontpage_option_panel',
    )
);

// Setting - drop down category for slider.
$wp_customize->add_setting('select_newsmaz_top_recent_post',
    array(
        'default' => $newsup_default['select_top_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);


$wp_customize->add_control(new Newsup_Dropdown_Taxonomies_Control($wp_customize, 'select_newsmaz_top_recent_post',
    array(
        'label' => esc_html__('Category', 'news-maz'),
        'description' => esc_html__('Select Category for top recent Post', 'news-maz'),
        'section' => 'newsmaz_top_recent_post_settings',
        'type' => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 90,
        'active_callback' => 'newsup_main_banner_section_status'
)));

}
add_action('customize_register', 'newsmaz_customize_register');
