<?php
/**
 * Template part for displaying single post layout two
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package News Express
 */

if ( has_post_thumbnail() ) {
    $custom_post_class = 'has-thumbnail';
} else {
    $custom_post_class = 'no-thumbnail';
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $custom_post_class ); ?>>

	<div class="post-thumbnail-wrap">
        <?php
        	news_express_post_thumbnail();
        	news_express_the_estimated_reading_time();
        ?>
        <div class="news-express-post-title-wrap">


			<header class="entry-header">
				<?php
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;

				if ( 'post' === get_post_type() ) :
				?>
					<div class="entry-meta news-express-flex post-cats-meta-wrap">
					<div class="post-cats-wrap">
						<?php news_express_the_post_categories_list( get_the_ID(), 1 ); ?>
					</div><!-- .post-cats-wrap -->
					<?php
						news_express_posted_on();
						news_express_posted_by();
						news_express_post_comment();
					 	news_express_entry_footer();
					?>
				</div><!-- .entry-meta -->
				<?php endif; ?>
			</header><!-- .entry-header -->
        </div> <!-- news-express-post-title-wrap -->
    </div> <!-- post-thumbnail-wrap -->
	<div class="news-express-post-content-wrap">
		<?php get_template_part( 'template-parts/partials/post/content' ); ?>
	</div> <!-- post-content-wrapper -->
</article><!-- #post-<?php the_ID(); ?> -->
