<?php
/**
 * Displays Author bio in single post
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_single_posts_author_enable = news_express_get_customizer_option_value( 'news_express_single_posts_author_enable' );

if ( ! is_single() || false === $news_express_single_posts_author_enable ) {
    return;
}

/**
 * hook - news_express_before_author_box
 * 
 * @since 1.0.0
 */
do_action( 'news_express_before_author_box' );

$author_id         = get_the_author_meta( 'ID' );
$author_avatar     = get_avatar( $author_id, 'thumbnail' );
$author_post_link  = get_the_author_posts_link();
$author_bio        = get_the_author_meta( 'description' );
$author_url        = get_the_author_meta( 'user_url' );

?>

<div class="post-author-box-wrapper">

        <?php if ( $author_avatar ) { ?>
            <div class="news-express-author__avatar">
                <?php echo wp_kses_post( $author_avatar ); ?>
            </div><!-- .news-express-author-avatar -->
        <?php } ?>

        <div class="news-express-author-info">
            <?php if ( $author_post_link ) { ?>
                    <h5 class="news-express-author-name"><?php echo wp_kses_post( $author_post_link ); ?></h5>
            <?php } ?>

            <?php if ( $author_bio ) { ?>
                <div class="news-express-author-bio">
                    <?php echo wp_kses_post( $author_bio ); ?>
                </div><!-- .news-express-author-bio -->
            <?php } ?>

            <div class="news-express-author-meta">
                <?php if ( $author_url ) { ?>
                    <div class="news-express-author-website">
                        <span><?php esc_html_e( 'Website', 'news-express' ); ?></span>
                        <a href="<?php echo esc_url( $author_url ); ?>" target="_blank"><?php echo esc_url( $author_url ); ?></a>
                    </div><!-- .news-express-author-website -->
                <?php } ?>
            </div><!-- .news-express-author-meta -->
        </div><!-- .news-express-author-info -->
</div><!-- .post-author-box-wrapper -->

<?php
/**
 * hook - news_express_after_author_box
 * 
 * @since 1.0.0
 */
do_action( 'news_express_after_author_box' );