<?php
/**
 * Partial template to display search icon.
 *
 * @package News Express
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$news_express_header_search_enable = news_express_get_customizer_option_value( 'news_express_header_search_enable' );
if ( false === $news_express_header_search_enable ) {
    return;
}

/**
 * hook: news_express_before_header_search
 *
 * @since 1.0.0
 */
do_action( 'news_express_before_header_search' );
?>

<div class="header-search-wrapper news-express-icon-elements">
    <span class="search-icon"><a href="javascript:void(0)"><i class="fas fa-search"></i></a></span>
    <div class="search-form-wrap">
        <?php get_search_form(); ?>
    </div><!-- .search-form-wrap -->
</div><!-- .header-search-wrapper -->

<?php
/**
 * hook: news_express_after_header_search
 *
 * @since 1.0.0
 */
do_action( 'news_express_after_header_search' );